/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemInstance;

public class CraftingContainer
implements Container {
    private ItemInstance[] items;
    private int width;
    private AbstractContainerMenu menu;

    public CraftingContainer(AbstractContainerMenu abstractContainerMenu, int n, int n2) {
        int n3 = n * n2;
        this.items = new ItemInstance[n3];
        this.menu = abstractContainerMenu;
        this.width = n;
    }

    public int getContainerSize() {
        return this.items.length;
    }

    public ItemInstance getItem(int n) {
        if (n >= this.getContainerSize()) {
            return null;
        }
        return this.items[n];
    }

    public ItemInstance getItem(int n, int n2) {
        if (n < 0 || n >= this.width) {
            return null;
        }
        int n3 = n + n2 * this.width;
        return this.getItem(n3);
    }

    public String getName() {
        return "Crafting";
    }

    public ItemInstance removeItem(int n, int n2) {
        if (this.items[n] != null) {
            if (this.items[n].count <= n2) {
                ItemInstance itemInstance = this.items[n];
                this.items[n] = null;
                this.menu.slotsChanged(this);
                return itemInstance;
            }
            ItemInstance itemInstance = this.items[n].remove(n2);
            if (this.items[n].count == 0) {
                this.items[n] = null;
            }
            this.menu.slotsChanged(this);
            return itemInstance;
        }
        return null;
    }

    public void setItem(int n, ItemInstance itemInstance) {
        this.items[n] = itemInstance;
        this.menu.slotsChanged(this);
    }

    public int getMaxStackSize() {
        return 64;
    }

    public void setChanged() {
    }

    public boolean stillValid(Player player) {
        return true;
    }
}

