/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemInstance;

public abstract class AbstractContainerMenu {
    public List<ItemInstance> lastSlots = new ArrayList<ItemInstance>();
    public List<Slot> slots = new ArrayList<Slot>();
    public int containerId = 0;
    private short changeUid = 0;
    protected List<ContainerListener> containerListeners = new ArrayList<ContainerListener>();
    private Set<Player> unSynchedPlayers = new HashSet<Player>();

    protected void addSlot(Slot slot) {
        slot.index = this.slots.size();
        this.slots.add(slot);
        this.lastSlots.add(null);
    }

    public void addSlotListener(ContainerListener containerListener) {
        this.containerListeners.add(containerListener);
        ArrayList<ItemInstance> arrayList = new ArrayList<ItemInstance>();
        for (int i = 0; i < this.slots.size(); ++i) {
            arrayList.add(this.slots.get(i).getItem());
        }
        containerListener.refreshContainer(this, arrayList);
        this.broadcastChanges();
    }

    public void sendData(int n, int n2) {
        for (int i = 0; i < this.containerListeners.size(); ++i) {
            this.containerListeners.get(i).setContainerData(this, n, n2);
        }
    }

    public void broadcastChanges() {
        for (int i = 0; i < this.slots.size(); ++i) {
            ItemInstance itemInstance = this.slots.get(i).getItem();
            ItemInstance itemInstance2 = this.lastSlots.get(i);
            if (ItemInstance.matches(itemInstance2, itemInstance)) continue;
            itemInstance2 = itemInstance == null ? null : itemInstance.copy();
            this.lastSlots.set(i, itemInstance2);
            for (int j = 0; j < this.containerListeners.size(); ++j) {
                this.containerListeners.get(j).slotChanged(this, i, itemInstance2);
            }
        }
    }

    public Slot getSlotFor(Container container, int n) {
        for (int i = 0; i < this.slots.size(); ++i) {
            Slot slot = this.slots.get(i);
            if (!slot.isAt(container, n)) continue;
            return slot;
        }
        return null;
    }

    public Slot getSlot(int n) {
        return this.slots.get(n);
    }

    public ItemInstance clicked(int n, int n2, Player player) {
        ItemInstance itemInstance = null;
        if (n2 == 0 || n2 == 1) {
            Inventory inventory = player.inventory;
            if (n == -999) {
                if (inventory.getCarried() != null && n == -999) {
                    if (n2 == 0) {
                        player.drop(inventory.getCarried());
                        inventory.setCarried(null);
                    }
                    if (n2 == 1) {
                        player.drop(inventory.getCarried().remove(1));
                        if (inventory.getCarried().count == 0) {
                            inventory.setCarried(null);
                        }
                    }
                }
            } else {
                Slot slot = this.slots.get(n);
                if (slot != null) {
                    slot.setChanged();
                    ItemInstance itemInstance2 = slot.getItem();
                    if (itemInstance2 != null) {
                        itemInstance = itemInstance2.copy();
                    }
                    if (itemInstance2 != null || inventory.getCarried() != null) {
                        if (itemInstance2 != null && inventory.getCarried() == null) {
                            int n3 = n2 == 0 ? itemInstance2.count : (itemInstance2.count + 1) / 2;
                            inventory.setCarried(slot.remove(n3));
                            if (itemInstance2.count == 0) {
                                slot.set(null);
                            }
                            slot.onTake();
                        } else if (itemInstance2 == null && inventory.getCarried() != null && slot.mayPlace(inventory.getCarried())) {
                            int n4;
                            int n5 = n4 = n2 == 0 ? inventory.getCarried().count : 1;
                            if (n4 > slot.getMaxStackSize()) {
                                n4 = slot.getMaxStackSize();
                            }
                            slot.set(inventory.getCarried().remove(n4));
                            if (inventory.getCarried().count == 0) {
                                inventory.setCarried(null);
                            }
                        } else if (itemInstance2 != null && inventory.getCarried() != null) {
                            if (slot.mayPlace(inventory.getCarried())) {
                                if (itemInstance2.id != inventory.getCarried().id || itemInstance2.isStackedByData() && itemInstance2.getAuxValue() != inventory.getCarried().getAuxValue()) {
                                    if (inventory.getCarried().count <= slot.getMaxStackSize()) {
                                        ItemInstance itemInstance3 = itemInstance2;
                                        slot.set(inventory.getCarried());
                                        inventory.setCarried(itemInstance3);
                                    }
                                } else if (itemInstance2.id == inventory.getCarried().id) {
                                    if (n2 == 0) {
                                        int n6 = inventory.getCarried().count;
                                        if (n6 > slot.getMaxStackSize() - itemInstance2.count) {
                                            n6 = slot.getMaxStackSize() - itemInstance2.count;
                                        }
                                        if (n6 > inventory.getCarried().getMaxStackSize() - itemInstance2.count) {
                                            n6 = inventory.getCarried().getMaxStackSize() - itemInstance2.count;
                                        }
                                        inventory.getCarried().remove(n6);
                                        if (inventory.getCarried().count == 0) {
                                            inventory.setCarried(null);
                                        }
                                        itemInstance2.count += n6;
                                    } else if (n2 == 1) {
                                        int n7 = 1;
                                        if (n7 > slot.getMaxStackSize() - itemInstance2.count) {
                                            n7 = slot.getMaxStackSize() - itemInstance2.count;
                                        }
                                        if (n7 > inventory.getCarried().getMaxStackSize() - itemInstance2.count) {
                                            n7 = inventory.getCarried().getMaxStackSize() - itemInstance2.count;
                                        }
                                        inventory.getCarried().remove(n7);
                                        if (inventory.getCarried().count == 0) {
                                            inventory.setCarried(null);
                                        }
                                        itemInstance2.count += n7;
                                    }
                                }
                            } else {
                                int n8;
                                ItemInstance itemInstance4 = inventory.getCarried();
                                if (!(itemInstance2.id != itemInstance4.id || itemInstance4.getMaxStackSize() <= 1 || itemInstance2.isStackedByData() && itemInstance2.getAuxValue() != itemInstance4.getAuxValue() || (n8 = itemInstance2.count) <= 0 || n8 + itemInstance4.count > itemInstance4.getMaxStackSize())) {
                                    itemInstance4.count += n8;
                                    itemInstance2.remove(n8);
                                    if (itemInstance2.count == 0) {
                                        slot.set(null);
                                    }
                                    slot.onTake();
                                }
                            }
                        }
                    }
                }
            }
        }
        return itemInstance;
    }

    public void removed(Player player) {
        Inventory inventory = player.inventory;
        if (inventory.getCarried() != null) {
            player.drop(inventory.getCarried());
            inventory.setCarried(null);
        }
    }

    public void slotsChanged(Container container) {
        this.broadcastChanges();
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void setItem(int n, ItemInstance itemInstance) {
        this.getSlot(n).set(itemInstance);
    }

    public void setAll(ItemInstance[] itemInstanceArray) {
        for (int i = 0; i < itemInstanceArray.length; ++i) {
            this.getSlot(i).set(itemInstanceArray[i]);
        }
    }

    public void setData(int n, int n2) {
    }

    public short backup(Inventory inventory) {
        this.changeUid = (short)(this.changeUid + 1);
        return this.changeUid;
    }

    public void deleteBackup(short s) {
    }

    public void rollbackToBackup(short s) {
    }

    public boolean isSynched(Player player) {
        return !this.unSynchedPlayers.contains(player);
    }

    public void setSynched(Player player, boolean bl) {
        if (bl) {
            this.unSynchedPlayers.remove(player);
        } else {
            this.unSynchedPlayers.add(player);
        }
    }

    public abstract boolean stillValid(Player var1);
}

