/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.mojang.nbt.CompoundTag;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import util.Mth;

public class Snowball
extends Entity {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private int lastTile = 0;
    private boolean inGround = false;
    public int shakeTime = 0;
    private Mob owner;
    private int life;
    private int flightTime = 0;

    public Snowball(Level level) {
        super(level);
        this.setSize(0.25f, 0.25f);
    }

    protected void defineSynchedData() {
    }

    public boolean shouldRenderAtSqrDistance(double d) {
        double d2 = this.bb.getSize() * 4.0;
        return d < (d2 *= 64.0) * d2;
    }

    public Snowball(Level level, Mob mob) {
        super(level);
        this.owner = mob;
        this.setSize(0.25f, 0.25f);
        this.moveTo(mob.x, mob.y + (double)mob.getHeadHeight(), mob.z, mob.yRot, mob.xRot);
        this.x -= (double)(Mth.cos(this.yRot / 180.0f * (float)Math.PI) * 0.16f);
        this.y -= (double)0.1f;
        this.z -= (double)(Mth.sin(this.yRot / 180.0f * (float)Math.PI) * 0.16f);
        this.setPos(this.x, this.y, this.z);
        this.heightOffset = 0.0f;
        float f = 0.4f;
        this.xd = -Mth.sin(this.yRot / 180.0f * (float)Math.PI) * Mth.cos(this.xRot / 180.0f * (float)Math.PI) * f;
        this.zd = Mth.cos(this.yRot / 180.0f * (float)Math.PI) * Mth.cos(this.xRot / 180.0f * (float)Math.PI) * f;
        this.yd = -Mth.sin(this.xRot / 180.0f * (float)Math.PI) * f;
        this.shoot(this.xd, this.yd, this.zd, 1.5f, 1.0f);
    }

    public Snowball(Level level, double d, double d2, double d3) {
        super(level);
        this.life = 0;
        this.setSize(0.25f, 0.25f);
        this.setPos(d, d2, d3);
        this.heightOffset = 0.0f;
    }

    public void shoot(double d, double d2, double d3, float f, float f2) {
        float f3 = Mth.sqrt(d * d + d2 * d2 + d3 * d3);
        d /= (double)f3;
        d2 /= (double)f3;
        d3 /= (double)f3;
        d += this.random.nextGaussian() * (double)0.0075f * (double)f2;
        d2 += this.random.nextGaussian() * (double)0.0075f * (double)f2;
        d3 += this.random.nextGaussian() * (double)0.0075f * (double)f2;
        this.xd = d *= (double)f;
        this.yd = d2 *= (double)f;
        this.zd = d3 *= (double)f;
        float f4 = Mth.sqrt(d * d + d3 * d3);
        this.yRotO = this.yRot = (float)(Math.atan2(d, d3) * 180.0 / 3.1415927410125732);
        this.xRotO = this.xRot = (float)(Math.atan2(d2, f4) * 180.0 / 3.1415927410125732);
        this.life = 0;
    }

    public void lerpMotion(double d, double d2, double d3) {
        this.xd = d;
        this.yd = d2;
        this.zd = d3;
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            float f = Mth.sqrt(d * d + d3 * d3);
            this.yRotO = this.yRot = (float)(Math.atan2(d, d3) * 180.0 / 3.1415927410125732);
            this.xRotO = this.xRot = (float)(Math.atan2(d2, f) * 180.0 / 3.1415927410125732);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void tick() {
        block18: {
            this.xOld = this.x;
            this.yOld = this.y;
            this.zOld = this.z;
            super.tick();
            if (this.shakeTime > 0) {
                --this.shakeTime;
            }
            if (this.inGround) {
                int n = this.level.getTile(this.xTile, this.yTile, this.zTile);
                if (n != this.lastTile) {
                    this.inGround = false;
                    this.xd *= (double)(this.random.nextFloat() * 0.2f);
                    this.yd *= (double)(this.random.nextFloat() * 0.2f);
                    this.zd *= (double)(this.random.nextFloat() * 0.2f);
                    this.life = 0;
                    this.flightTime = 0;
                    break block18;
                } else {
                    ++this.life;
                    if (this.life == 1200) {
                        this.remove();
                    }
                    return;
                }
            }
            ++this.flightTime;
        }
        Vec3 vec3 = Vec3.newTemp(this.x, this.y, this.z);
        Vec3 vec32 = Vec3.newTemp(this.x + this.xd, this.y + this.yd, this.z + this.zd);
        HitResult hitResult = this.level.clip(vec3, vec32);
        vec3 = Vec3.newTemp(this.x, this.y, this.z);
        vec32 = Vec3.newTemp(this.x + this.xd, this.y + this.yd, this.z + this.zd);
        if (hitResult != null) {
            vec32 = Vec3.newTemp(hitResult.pos.x, hitResult.pos.y, hitResult.pos.z);
        }
        if (!this.level.isOnline) {
            Entity entity = null;
            List<Entity> list = this.level.getEntities(this, this.bb.expand(this.xd, this.yd, this.zd).grow(1.0, 1.0, 1.0));
            double d = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                double d2;
                float f;
                AABB aABB;
                HitResult hitResult2;
                Entity entity2 = list.get(i);
                if (!entity2.isPickable() || entity2 == this.owner && this.flightTime < 5 || (hitResult2 = (aABB = entity2.bb.grow(f = 0.3f, f, f)).clip(vec3, vec32)) == null || !((d2 = vec3.distanceTo(hitResult2.pos)) < d) && d != 0.0) continue;
                entity = entity2;
                d = d2;
            }
            if (entity != null) {
                hitResult = new HitResult(entity);
            }
        }
        if (hitResult != null) {
            if (hitResult.entity == null || hitResult.entity.hurt(this.owner, 0)) {
                // empty if block
            }
            for (int i = 0; i < 8; ++i) {
                this.level.addParticle("snowballpoof", this.x, this.y, this.z, 0.0, 0.0, 0.0);
            }
            this.remove();
        }
        this.x += this.xd;
        this.y += this.yd;
        this.z += this.zd;
        float f = Mth.sqrt(this.xd * this.xd + this.zd * this.zd);
        this.yRot = (float)(Math.atan2(this.xd, this.zd) * 180.0 / 3.1415927410125732);
        this.xRot = (float)(Math.atan2(this.yd, f) * 180.0 / 3.1415927410125732);
        while (this.xRot - this.xRotO < -180.0f) {
            this.xRotO -= 360.0f;
        }
        while (this.xRot - this.xRotO >= 180.0f) {
            this.xRotO += 360.0f;
        }
        while (this.yRot - this.yRotO < -180.0f) {
            this.yRotO -= 360.0f;
        }
        while (this.yRot - this.yRotO >= 180.0f) {
            this.yRotO += 360.0f;
        }
        this.xRot = this.xRotO + (this.xRot - this.xRotO) * 0.2f;
        this.yRot = this.yRotO + (this.yRot - this.yRotO) * 0.2f;
        float f2 = 0.99f;
        float f3 = 0.03f;
        if (this.isInWater()) {
            for (int i = 0; i < 4; ++i) {
                float f4 = 0.25f;
                this.level.addParticle("bubble", this.x - this.xd * (double)f4, this.y - this.yd * (double)f4, this.z - this.zd * (double)f4, this.xd, this.yd, this.zd);
            }
            f2 = 0.8f;
        }
        this.xd *= (double)f2;
        this.yd *= (double)f2;
        this.zd *= (double)f2;
        this.yd -= (double)f3;
        this.setPos(this.x, this.y, this.z);
    }

    public void addAdditonalSaveData(CompoundTag compoundTag) {
        compoundTag.putShort("xTile", (short)this.xTile);
        compoundTag.putShort("yTile", (short)this.yTile);
        compoundTag.putShort("zTile", (short)this.zTile);
        compoundTag.putByte("inTile", (byte)this.lastTile);
        compoundTag.putByte("shake", (byte)this.shakeTime);
        compoundTag.putByte("inGround", (byte)(this.inGround ? 1 : 0));
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        this.xTile = compoundTag.getShort("xTile");
        this.yTile = compoundTag.getShort("yTile");
        this.zTile = compoundTag.getShort("zTile");
        this.lastTile = compoundTag.getByte("inTile") & 0xFF;
        this.shakeTime = compoundTag.getByte("shake") & 0xFF;
        this.inGround = compoundTag.getByte("inGround") == 1;
    }

    public void playerTouch(Player player) {
        if (this.inGround && this.owner == player && this.shakeTime <= 0 && player.inventory.add(new ItemInstance(Item.arrow, 1))) {
            this.level.playSound(this, "random.pop", 0.2f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            player.take(this, 1);
            this.remove();
        }
    }

    public float getShadowHeightOffs() {
        return 0.0f;
    }
}

