/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.mojang.nbt.CompoundTag;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import util.Mth;

public class FishingHook
extends Entity {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private int lastTile = 0;
    private boolean inGround = false;
    public int shakeTime = 0;
    public Player owner;
    private int life;
    private int flightTime = 0;
    private int nibble = 0;
    public Entity hookedIn = null;
    private int lSteps;
    private double lx;
    private double ly;
    private double lz;
    private double lyr;
    private double lxr;
    private double lxd;
    private double lyd;
    private double lzd;

    public FishingHook(Level level) {
        super(level);
        this.setSize(0.25f, 0.25f);
    }

    protected void defineSynchedData() {
    }

    public boolean shouldRenderAtSqrDistance(double d) {
        double d2 = this.bb.getSize() * 4.0;
        return d < (d2 *= 64.0) * d2;
    }

    public FishingHook(Level level, double d, double d2, double d3) {
        this(level);
        this.setPos(d, d2, d3);
    }

    public FishingHook(Level level, Player player) {
        super(level);
        this.owner = player;
        this.owner.fishing = this;
        this.setSize(0.25f, 0.25f);
        this.moveTo(player.x, player.y + 1.62 - (double)player.heightOffset, player.z, player.yRot, player.xRot);
        this.x -= (double)(Mth.cos(this.yRot / 180.0f * (float)Math.PI) * 0.16f);
        this.y -= (double)0.1f;
        this.z -= (double)(Mth.sin(this.yRot / 180.0f * (float)Math.PI) * 0.16f);
        this.setPos(this.x, this.y, this.z);
        this.heightOffset = 0.0f;
        float f = 0.4f;
        this.xd = -Mth.sin(this.yRot / 180.0f * (float)Math.PI) * Mth.cos(this.xRot / 180.0f * (float)Math.PI) * f;
        this.zd = Mth.cos(this.yRot / 180.0f * (float)Math.PI) * Mth.cos(this.xRot / 180.0f * (float)Math.PI) * f;
        this.yd = -Mth.sin(this.xRot / 180.0f * (float)Math.PI) * f;
        this.shoot(this.xd, this.yd, this.zd, 1.5f, 1.0f);
    }

    public void shoot(double d, double d2, double d3, float f, float f2) {
        float f3 = Mth.sqrt(d * d + d2 * d2 + d3 * d3);
        d /= (double)f3;
        d2 /= (double)f3;
        d3 /= (double)f3;
        d += this.random.nextGaussian() * (double)0.0075f * (double)f2;
        d2 += this.random.nextGaussian() * (double)0.0075f * (double)f2;
        d3 += this.random.nextGaussian() * (double)0.0075f * (double)f2;
        this.xd = d *= (double)f;
        this.yd = d2 *= (double)f;
        this.zd = d3 *= (double)f;
        float f4 = Mth.sqrt(d * d + d3 * d3);
        this.yRotO = this.yRot = (float)(Math.atan2(d, d3) * 180.0 / 3.1415927410125732);
        this.xRotO = this.xRot = (float)(Math.atan2(d2, f4) * 180.0 / 3.1415927410125732);
        this.life = 0;
    }

    public void lerpTo(double d, double d2, double d3, float f, float f2, int n) {
        this.lx = d;
        this.ly = d2;
        this.lz = d3;
        this.lyr = f;
        this.lxr = f2;
        this.lSteps = n;
        this.xd = this.lxd;
        this.yd = this.lyd;
        this.zd = this.lzd;
    }

    public void lerpMotion(double d, double d2, double d3) {
        this.lxd = this.xd = d;
        this.lyd = this.yd = d2;
        this.lzd = this.zd = d3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void tick() {
        block35: {
            super.tick();
            if (this.lSteps > 0) {
                double d;
                double d2 = this.x + (this.lx - this.x) / (double)this.lSteps;
                double d3 = this.y + (this.ly - this.y) / (double)this.lSteps;
                double d4 = this.z + (this.lz - this.z) / (double)this.lSteps;
                for (d = this.lyr - (double)this.yRot; d < -180.0; d += 360.0) {
                }
                while (true) {
                    if (!(d >= 180.0)) {
                        this.yRot = (float)((double)this.yRot + d / (double)this.lSteps);
                        this.xRot = (float)((double)this.xRot + (this.lxr - (double)this.xRot) / (double)this.lSteps);
                        --this.lSteps;
                        this.setPos(d2, d3, d4);
                        this.setRot(this.yRot, this.xRot);
                        return;
                    }
                    d -= 360.0;
                }
            }
            if (!this.level.isOnline) {
                ItemInstance itemInstance = this.owner.getSelectedItem();
                if (this.owner.removed || !this.owner.isAlive() || itemInstance == null || itemInstance.getItem() != Item.fishingRod || this.distanceToSqr(this.owner) > 1024.0) {
                    this.remove();
                    this.owner.fishing = null;
                    return;
                }
                if (this.hookedIn != null) {
                    if (!this.hookedIn.removed) {
                        this.x = this.hookedIn.x;
                        this.y = this.hookedIn.bb.y0 + (double)this.hookedIn.bbHeight * 0.8;
                        this.z = this.hookedIn.z;
                        return;
                    }
                    this.hookedIn = null;
                }
            }
            if (this.shakeTime > 0) {
                --this.shakeTime;
            }
            if (this.inGround) {
                int n = this.level.getTile(this.xTile, this.yTile, this.zTile);
                if (n != this.lastTile) {
                    this.inGround = false;
                    this.xd *= (double)(this.random.nextFloat() * 0.2f);
                    this.yd *= (double)(this.random.nextFloat() * 0.2f);
                    this.zd *= (double)(this.random.nextFloat() * 0.2f);
                    this.life = 0;
                    this.flightTime = 0;
                    break block35;
                } else {
                    ++this.life;
                    if (this.life == 1200) {
                        this.remove();
                    }
                    return;
                }
            }
            ++this.flightTime;
        }
        Vec3 vec3 = Vec3.newTemp(this.x, this.y, this.z);
        Vec3 vec32 = Vec3.newTemp(this.x + this.xd, this.y + this.yd, this.z + this.zd);
        HitResult hitResult = this.level.clip(vec3, vec32);
        vec3 = Vec3.newTemp(this.x, this.y, this.z);
        vec32 = Vec3.newTemp(this.x + this.xd, this.y + this.yd, this.z + this.zd);
        if (hitResult != null) {
            vec32 = Vec3.newTemp(hitResult.pos.x, hitResult.pos.y, hitResult.pos.z);
        }
        Entity entity = null;
        List<Entity> list = this.level.getEntities(this, this.bb.expand(this.xd, this.yd, this.zd).grow(1.0, 1.0, 1.0));
        double d = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d5;
            float f;
            AABB aABB;
            HitResult hitResult2;
            Entity entity2 = list.get(i);
            if (!entity2.isPickable() || entity2 == this.owner && this.flightTime < 5 || (hitResult2 = (aABB = entity2.bb.grow(f = 0.3f, f, f)).clip(vec3, vec32)) == null || !((d5 = vec3.distanceTo(hitResult2.pos)) < d) && d != 0.0) continue;
            entity = entity2;
            d = d5;
        }
        if (entity != null) {
            hitResult = new HitResult(entity);
        }
        if (hitResult != null) {
            if (hitResult.entity != null) {
                if (hitResult.entity.hurt(this.owner, 0)) {
                    this.hookedIn = hitResult.entity;
                }
            } else {
                this.inGround = true;
            }
        }
        if (this.inGround) {
            return;
        }
        this.move(this.xd, this.yd, this.zd);
        float f = Mth.sqrt(this.xd * this.xd + this.zd * this.zd);
        this.yRot = (float)(Math.atan2(this.xd, this.zd) * 180.0 / 3.1415927410125732);
        this.xRot = (float)(Math.atan2(this.yd, f) * 180.0 / 3.1415927410125732);
        while (this.xRot - this.xRotO < -180.0f) {
            this.xRotO -= 360.0f;
        }
        while (this.xRot - this.xRotO >= 180.0f) {
            this.xRotO += 360.0f;
        }
        while (this.yRot - this.yRotO < -180.0f) {
            this.yRotO -= 360.0f;
        }
        while (this.yRot - this.yRotO >= 180.0f) {
            this.yRotO += 360.0f;
        }
        this.xRot = this.xRotO + (this.xRot - this.xRotO) * 0.2f;
        this.yRot = this.yRotO + (this.yRot - this.yRotO) * 0.2f;
        float f2 = 0.92f;
        if (this.onGround || this.horizontalCollision) {
            f2 = 0.5f;
        }
        int n = 5;
        double d6 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d7 = this.bb.y0 + (this.bb.y1 - this.bb.y0) * (double)(i + 0) / (double)n - 0.125 + 0.125;
            double d8 = this.bb.y0 + (this.bb.y1 - this.bb.y0) * (double)(i + 1) / (double)n - 0.125 + 0.125;
            AABB aABB = AABB.newTemp(this.bb.x0, d7, this.bb.z0, this.bb.x1, d8, this.bb.z1);
            if (!this.level.containsLiquid(aABB, Material.water)) continue;
            d6 += 1.0 / (double)n;
        }
        if (d6 > 0.0) {
            if (this.nibble > 0) {
                --this.nibble;
            } else if (this.random.nextInt(500) == 0) {
                float f3;
                this.nibble = this.random.nextInt(30) + 10;
                this.yd -= (double)0.2f;
                this.level.playSound(this, "random.splash", 0.25f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                float f4 = Mth.floor(this.bb.y0);
                int n2 = 0;
                while ((float)n2 < 1.0f + this.bbWidth * 20.0f) {
                    f3 = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
                    float f5 = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
                    this.level.addParticle("bubble", this.x + (double)f3, f4 + 1.0f, this.z + (double)f5, this.xd, this.yd - (double)(this.random.nextFloat() * 0.2f), this.zd);
                    ++n2;
                }
                n2 = 0;
                while ((float)n2 < 1.0f + this.bbWidth * 20.0f) {
                    f3 = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
                    float f6 = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
                    this.level.addParticle("splash", this.x + (double)f3, f4 + 1.0f, this.z + (double)f6, this.xd, this.yd, this.zd);
                    ++n2;
                }
            }
        }
        if (this.nibble > 0) {
            this.yd -= (double)(this.random.nextFloat() * this.random.nextFloat() * this.random.nextFloat()) * 0.2;
        }
        double d9 = d6 * 2.0 - 1.0;
        this.yd += (double)0.04f * d9;
        if (d6 > 0.0) {
            f2 = (float)((double)f2 * 0.9);
            this.yd *= 0.8;
        }
        this.xd *= (double)f2;
        this.yd *= (double)f2;
        this.zd *= (double)f2;
        this.setPos(this.x, this.y, this.z);
    }

    public void addAdditonalSaveData(CompoundTag compoundTag) {
        compoundTag.putShort("xTile", (short)this.xTile);
        compoundTag.putShort("yTile", (short)this.yTile);
        compoundTag.putShort("zTile", (short)this.zTile);
        compoundTag.putByte("inTile", (byte)this.lastTile);
        compoundTag.putByte("shake", (byte)this.shakeTime);
        compoundTag.putByte("inGround", (byte)(this.inGround ? 1 : 0));
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        this.xTile = compoundTag.getShort("xTile");
        this.yTile = compoundTag.getShort("yTile");
        this.zTile = compoundTag.getShort("zTile");
        this.lastTile = compoundTag.getByte("inTile") & 0xFF;
        this.shakeTime = compoundTag.getByte("shake") & 0xFF;
        this.inGround = compoundTag.getByte("inGround") == 1;
    }

    public float getShadowHeightOffs() {
        return 0.0f;
    }

    public int retrieve() {
        int n = 0;
        if (this.hookedIn != null) {
            double d = this.owner.x - this.x;
            double d2 = this.owner.y - this.y;
            double d3 = this.owner.z - this.z;
            double d4 = Mth.sqrt(d * d + d2 * d2 + d3 * d3);
            double d5 = 0.1;
            this.hookedIn.xd += d * d5;
            this.hookedIn.yd += d2 * d5 + (double)Mth.sqrt(d4) * 0.08;
            this.hookedIn.zd += d3 * d5;
            n = 3;
        } else if (this.nibble > 0) {
            ItemEntity itemEntity = new ItemEntity(this.level, this.x, this.y, this.z, new ItemInstance(Item.fish_raw));
            double d = this.owner.x - this.x;
            double d6 = this.owner.y - this.y;
            double d7 = this.owner.z - this.z;
            double d8 = Mth.sqrt(d * d + d6 * d6 + d7 * d7);
            double d9 = 0.1;
            itemEntity.xd = d * d9;
            itemEntity.yd = d6 * d9 + (double)Mth.sqrt(d8) * 0.08;
            itemEntity.zd = d7 * d9;
            this.level.addEntity(itemEntity);
            n = 1;
        }
        if (this.inGround) {
            n = 2;
        }
        this.remove();
        this.owner.fishing = null;
        return n;
    }
}

