/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.mojang.nbt.CompoundTag;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import util.Mth;

public class Fireball
extends Entity {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private int lastTile = 0;
    private boolean inGround = false;
    public int shakeTime = 0;
    private Mob owner;
    private int life;
    private int flightTime = 0;
    public double xPower;
    public double yPower;
    public double zPower;

    public Fireball(Level level) {
        super(level);
        this.setSize(1.0f, 1.0f);
    }

    protected void defineSynchedData() {
    }

    public boolean shouldRenderAtSqrDistance(double d) {
        double d2 = this.bb.getSize() * 4.0;
        return d < (d2 *= 64.0) * d2;
    }

    public Fireball(Level level, Mob mob, double d, double d2, double d3) {
        super(level);
        this.owner = mob;
        this.setSize(1.0f, 1.0f);
        this.moveTo(mob.x, mob.y, mob.z, mob.yRot, mob.xRot);
        this.setPos(this.x, this.y, this.z);
        this.heightOffset = 0.0f;
        this.zd = 0.0;
        this.yd = 0.0;
        this.xd = 0.0;
        double d4 = Mth.sqrt((d += this.random.nextGaussian() * 0.4) * d + (d2 += this.random.nextGaussian() * 0.4) * d2 + (d3 += this.random.nextGaussian() * 0.4) * d3);
        this.xPower = d / d4 * 0.1;
        this.yPower = d2 / d4 * 0.1;
        this.zPower = d3 / d4 * 0.1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void tick() {
        block16: {
            super.tick();
            this.onFire = 10;
            if (this.shakeTime > 0) {
                --this.shakeTime;
            }
            if (this.inGround) {
                int n = this.level.getTile(this.xTile, this.yTile, this.zTile);
                if (n != this.lastTile) {
                    this.inGround = false;
                    this.xd *= (double)(this.random.nextFloat() * 0.2f);
                    this.yd *= (double)(this.random.nextFloat() * 0.2f);
                    this.zd *= (double)(this.random.nextFloat() * 0.2f);
                    this.life = 0;
                    this.flightTime = 0;
                    break block16;
                } else {
                    ++this.life;
                    if (this.life == 1200) {
                        this.remove();
                    }
                    return;
                }
            }
            ++this.flightTime;
        }
        Vec3 vec3 = Vec3.newTemp(this.x, this.y, this.z);
        Vec3 vec32 = Vec3.newTemp(this.x + this.xd, this.y + this.yd, this.z + this.zd);
        HitResult hitResult = this.level.clip(vec3, vec32);
        vec3 = Vec3.newTemp(this.x, this.y, this.z);
        vec32 = Vec3.newTemp(this.x + this.xd, this.y + this.yd, this.z + this.zd);
        if (hitResult != null) {
            vec32 = Vec3.newTemp(hitResult.pos.x, hitResult.pos.y, hitResult.pos.z);
        }
        Entity entity = null;
        List<Entity> list = this.level.getEntities(this, this.bb.expand(this.xd, this.yd, this.zd).grow(1.0, 1.0, 1.0));
        double d = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d2;
            float f;
            AABB aABB;
            HitResult hitResult2;
            Entity entity2 = list.get(i);
            if (!entity2.isPickable() || entity2 == this.owner && this.flightTime < 25 || (hitResult2 = (aABB = entity2.bb.grow(f = 0.3f, f, f)).clip(vec3, vec32)) == null || !((d2 = vec3.distanceTo(hitResult2.pos)) < d) && d != 0.0) continue;
            entity = entity2;
            d = d2;
        }
        if (entity != null) {
            hitResult = new HitResult(entity);
        }
        if (hitResult != null) {
            if (hitResult.entity == null || hitResult.entity.hurt(this.owner, 0)) {
                // empty if block
            }
            this.level.explode(null, this.x, this.y, this.z, 1.0f, true);
            this.remove();
        }
        this.x += this.xd;
        this.y += this.yd;
        this.z += this.zd;
        float f = Mth.sqrt(this.xd * this.xd + this.zd * this.zd);
        this.yRot = (float)(Math.atan2(this.xd, this.zd) * 180.0 / 3.1415927410125732);
        this.xRot = (float)(Math.atan2(this.yd, f) * 180.0 / 3.1415927410125732);
        while (this.xRot - this.xRotO < -180.0f) {
            this.xRotO -= 360.0f;
        }
        while (this.xRot - this.xRotO >= 180.0f) {
            this.xRotO += 360.0f;
        }
        while (this.yRot - this.yRotO < -180.0f) {
            this.yRotO -= 360.0f;
        }
        while (this.yRot - this.yRotO >= 180.0f) {
            this.yRotO += 360.0f;
        }
        this.xRot = this.xRotO + (this.xRot - this.xRotO) * 0.2f;
        this.yRot = this.yRotO + (this.yRot - this.yRotO) * 0.2f;
        float f2 = 0.95f;
        if (this.isInWater()) {
            for (int i = 0; i < 4; ++i) {
                float f3 = 0.25f;
                this.level.addParticle("bubble", this.x - this.xd * (double)f3, this.y - this.yd * (double)f3, this.z - this.zd * (double)f3, this.xd, this.yd, this.zd);
            }
            f2 = 0.8f;
        }
        this.xd += this.xPower;
        this.yd += this.yPower;
        this.zd += this.zPower;
        this.xd *= (double)f2;
        this.yd *= (double)f2;
        this.zd *= (double)f2;
        this.level.addParticle("smoke", this.x, this.y + 0.5, this.z, 0.0, 0.0, 0.0);
        this.setPos(this.x, this.y, this.z);
    }

    public void addAdditonalSaveData(CompoundTag compoundTag) {
        compoundTag.putShort("xTile", (short)this.xTile);
        compoundTag.putShort("yTile", (short)this.yTile);
        compoundTag.putShort("zTile", (short)this.zTile);
        compoundTag.putByte("inTile", (byte)this.lastTile);
        compoundTag.putByte("shake", (byte)this.shakeTime);
        compoundTag.putByte("inGround", (byte)(this.inGround ? 1 : 0));
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        this.xTile = compoundTag.getShort("xTile");
        this.yTile = compoundTag.getShort("yTile");
        this.zTile = compoundTag.getShort("zTile");
        this.lastTile = compoundTag.getByte("inTile") & 0xFF;
        this.shakeTime = compoundTag.getByte("shake") & 0xFF;
        this.inGround = compoundTag.getByte("inGround") == 1;
    }

    public boolean isPickable() {
        return true;
    }

    public float getPickRadius() {
        return 1.0f;
    }

    public boolean hurt(Entity entity, int n) {
        this.markHurt();
        if (entity != null) {
            Vec3 vec3 = entity.getLookAngle();
            if (vec3 != null) {
                this.xd = vec3.x;
                this.yd = vec3.y;
                this.zd = vec3.z;
                this.xPower = this.xd * 0.1;
                this.yPower = this.yd * 0.1;
                this.zPower = this.zd * 0.1;
            }
            return true;
        }
        return false;
    }

    public float getShadowHeightOffs() {
        return 0.0f;
    }
}

