/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.ListTag;
import com.mojang.nbt.Tag;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.level.tile.entity.DispenserTileEntity;
import net.minecraft.world.level.tile.entity.FurnaceTileEntity;
import net.minecraft.world.level.tile.entity.SignTileEntity;
import util.Mth;

public abstract class Player
extends Mob {
    public static final int MAX_HEALTH = 20;
    public static final int SWING_DURATION = 8;
    public Inventory inventory = new Inventory(this);
    public AbstractContainerMenu inventoryMenu;
    public AbstractContainerMenu containerMenu;
    public byte userType = 0;
    public int score = 0;
    public float oBob;
    public float bob;
    public boolean swinging = false;
    public int swingTime = 0;
    public String name;
    public int dimension;
    public String cloakTexture;
    public double xCloakO;
    public double yCloakO;
    public double zCloakO;
    public double xCloak;
    public double yCloak;
    public double zCloak;
    private int dmgSpill = 0;
    public FishingHook fishing = null;

    public Player(Level level) {
        super(level);
        this.containerMenu = this.inventoryMenu = new InventoryMenu(this.inventory, !level.isOnline);
        this.heightOffset = 1.62f;
        this.moveTo((double)level.xSpawn + 0.5, level.ySpawn + 1, (double)level.zSpawn + 0.5, 0.0f, 0.0f);
        this.health = 20;
        this.modelName = "humanoid";
        this.rotOffs = 180.0f;
        this.flameTime = 20;
        this.textureName = "/mob/char.png";
    }

    public void tick() {
        super.tick();
        if (!this.level.isOnline && this.containerMenu != null && !this.containerMenu.stillValid(this)) {
            this.closeContainer();
            this.containerMenu = this.inventoryMenu;
        }
        this.xCloakO = this.xCloak;
        this.yCloakO = this.yCloak;
        this.zCloakO = this.zCloak;
        double d = this.x - this.xCloak;
        double d2 = this.y - this.yCloak;
        double d3 = this.z - this.zCloak;
        double d4 = 10.0;
        if (d > d4) {
            this.xCloakO = this.xCloak = this.x;
        }
        if (d3 > d4) {
            this.zCloakO = this.zCloak = this.z;
        }
        if (d2 > d4) {
            this.yCloakO = this.yCloak = this.y;
        }
        if (d < -d4) {
            this.xCloakO = this.xCloak = this.x;
        }
        if (d3 < -d4) {
            this.zCloakO = this.zCloak = this.z;
        }
        if (d2 < -d4) {
            this.yCloakO = this.yCloak = this.y;
        }
        this.xCloak += d * 0.25;
        this.zCloak += d3 * 0.25;
        this.yCloak += d2 * 0.25;
    }

    protected void closeContainer() {
        this.containerMenu = this.inventoryMenu;
    }

    public void prepareCustomTextures() {
        this.customTextureUrl2 = this.cloakTexture = "http://s3.amazonaws.com/MinecraftCloaks/" + this.name + ".png";
    }

    public void rideTick() {
        super.rideTick();
        this.oBob = this.bob;
        this.bob = 0.0f;
    }

    public void resetPos() {
        this.heightOffset = 1.62f;
        this.setSize(0.6f, 1.8f);
        super.resetPos();
        this.health = 20;
        this.deathTime = 0;
    }

    protected void updateAi() {
        if (this.swinging) {
            ++this.swingTime;
            if (this.swingTime == 8) {
                this.swingTime = 0;
                this.swinging = false;
            }
        } else {
            this.swingTime = 0;
        }
        this.attackAnim = (float)this.swingTime / 8.0f;
    }

    public void aiStep() {
        List<Entity> list;
        if (this.level.difficulty == 0 && this.health < 20 && this.tickCount % 20 * 12 == 0) {
            this.heal(1);
        }
        this.inventory.tick();
        this.oBob = this.bob;
        super.aiStep();
        float f = Mth.sqrt(this.xd * this.xd + this.zd * this.zd);
        float f2 = (float)Math.atan(-this.yd * (double)0.2f) * 15.0f;
        if (f > 0.1f) {
            f = 0.1f;
        }
        if (!this.onGround || this.health <= 0) {
            f = 0.0f;
        }
        if (this.onGround || this.health <= 0) {
            f2 = 0.0f;
        }
        this.bob += (f - this.bob) * 0.4f;
        this.tilt += (f2 - this.tilt) * 0.8f;
        if (this.health > 0 && (list = this.level.getEntities(this, this.bb.grow(1.0, 0.0, 1.0))) != null) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = list.get(i);
                if (entity.removed) continue;
                this.touch(entity);
            }
        }
    }

    private void touch(Entity entity) {
        entity.playerTouch(this);
    }

    public boolean addResource(int n) {
        return this.inventory.add(new ItemInstance(n, 1, 0));
    }

    public int getScore() {
        return this.score;
    }

    public void die(Entity entity) {
        super.die(entity);
        this.setSize(0.2f, 0.2f);
        this.setPos(this.x, this.y, this.z);
        this.yd = 0.1f;
        if (this.name.equals("Notch")) {
            this.drop(new ItemInstance(Item.apple, 1), true);
        }
        this.inventory.dropAll();
        if (entity != null) {
            this.xd = -Mth.cos((this.hurtDir + this.yRot) * (float)Math.PI / 180.0f) * 0.1f;
            this.zd = -Mth.sin((this.hurtDir + this.yRot) * (float)Math.PI / 180.0f) * 0.1f;
        } else {
            this.zd = 0.0;
            this.xd = 0.0;
        }
        this.heightOffset = 0.1f;
    }

    public void awardKillScore(Entity entity, int n) {
        this.score += n;
    }

    public boolean isShootable() {
        return true;
    }

    public boolean isCreativeModeAllowed() {
        return true;
    }

    public void drop() {
        this.drop(this.inventory.removeItem(this.inventory.selected, 1), false);
    }

    public void drop(ItemInstance itemInstance) {
        this.drop(itemInstance, false);
    }

    public void drop(ItemInstance itemInstance, boolean bl) {
        if (itemInstance == null) {
            return;
        }
        ItemEntity itemEntity = new ItemEntity(this.level, this.x, this.y - (double)0.3f + (double)this.getHeadHeight(), this.z, itemInstance);
        itemEntity.throwTime = 40;
        float f = 0.1f;
        if (bl) {
            float f2 = this.random.nextFloat() * 0.5f;
            float f3 = this.random.nextFloat() * (float)Math.PI * 2.0f;
            itemEntity.xd = -Mth.sin(f3) * f2;
            itemEntity.zd = Mth.cos(f3) * f2;
            itemEntity.yd = 0.2f;
        } else {
            f = 0.3f;
            itemEntity.xd = -Mth.sin(this.yRot / 180.0f * (float)Math.PI) * Mth.cos(this.xRot / 180.0f * (float)Math.PI) * f;
            itemEntity.zd = Mth.cos(this.yRot / 180.0f * (float)Math.PI) * Mth.cos(this.xRot / 180.0f * (float)Math.PI) * f;
            itemEntity.yd = -Mth.sin(this.xRot / 180.0f * (float)Math.PI) * f + 0.1f;
            f = 0.02f;
            float f4 = this.random.nextFloat() * (float)Math.PI * 2.0f;
            itemEntity.xd += Math.cos(f4) * (double)(f *= this.random.nextFloat());
            itemEntity.yd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
            itemEntity.zd += Math.sin(f4) * (double)f;
        }
        this.reallyDrop(itemEntity);
    }

    protected void reallyDrop(ItemEntity itemEntity) {
        this.level.addEntity(itemEntity);
    }

    public float getDestroySpeed(Tile tile) {
        float f = this.inventory.getDestroySpeed(tile);
        if (this.isUnderLiquid(Material.water)) {
            f /= 5.0f;
        }
        if (!this.onGround) {
            f /= 5.0f;
        }
        return f;
    }

    public boolean canDestroy(Tile tile) {
        return this.inventory.canDestroy(tile);
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        ListTag<? extends Tag> listTag = compoundTag.getList("Inventory");
        this.inventory.load(listTag);
        this.dimension = compoundTag.getInt("Dimension");
    }

    public void addAdditonalSaveData(CompoundTag compoundTag) {
        super.addAdditonalSaveData(compoundTag);
        compoundTag.put("Inventory", this.inventory.save(new ListTag<CompoundTag>()));
        compoundTag.putInt("Dimension", this.dimension);
    }

    public void openContainer(Container container) {
    }

    public void startCrafting(int n, int n2, int n3) {
    }

    public void take(Entity entity, int n) {
    }

    public float getHeadHeight() {
        return 0.12f;
    }

    public boolean hurt(Entity entity, int n) {
        this.noActionTime = 0;
        if (this.health <= 0) {
            return false;
        }
        if (entity instanceof Monster || entity instanceof Arrow) {
            if (this.level.difficulty == 0) {
                n = 0;
            }
            if (this.level.difficulty == 1) {
                n = n / 3 + 1;
            }
            if (this.level.difficulty == 3) {
                n = n * 3 / 2;
            }
        }
        if (n == 0) {
            return false;
        }
        return super.hurt(entity, n);
    }

    protected void actuallyHurt(int n) {
        int n2 = 25 - this.inventory.getArmorValue();
        int n3 = n * n2 + this.dmgSpill;
        this.inventory.hurtArmor(n);
        n = n3 / 25;
        this.dmgSpill = n3 % 25;
        super.actuallyHurt(n);
    }

    public void openFurnace(FurnaceTileEntity furnaceTileEntity) {
    }

    public void openTrap(DispenserTileEntity dispenserTileEntity) {
    }

    public void openTextEdit(SignTileEntity signTileEntity) {
    }

    public void interact(Entity entity) {
        if (entity.interact(this)) {
            return;
        }
        ItemInstance itemInstance = this.getSelectedItem();
        if (itemInstance != null && entity instanceof Mob) {
            itemInstance.interactEnemy((Mob)entity);
            if (itemInstance.count <= 0) {
                itemInstance.snap(this);
                this.removeSelectedItem();
            }
        }
    }

    public ItemInstance getSelectedItem() {
        return this.inventory.getSelected();
    }

    public void removeSelectedItem() {
        this.inventory.setItem(this.inventory.selected, null);
    }

    public double getRidingHeight() {
        return this.heightOffset - 0.5f;
    }

    public void swing() {
        this.swingTime = -1;
        this.swinging = true;
    }

    public void attack(Entity entity) {
        int n = this.inventory.getAttackDamage(entity);
        if (n > 0) {
            entity.hurt(this, n);
            ItemInstance itemInstance = this.getSelectedItem();
            if (itemInstance != null && entity instanceof Mob) {
                itemInstance.hurtEnemy((Mob)entity);
                if (itemInstance.count <= 0) {
                    itemInstance.snap(this);
                    this.removeSelectedItem();
                }
            }
        }
    }

    public void respawn() {
    }

    public Slot getInventorySlot(int n) {
        return null;
    }

    public void carriedChanged(ItemInstance itemInstance) {
    }

    public void remove() {
        super.remove();
        this.inventoryMenu.removed(this);
        if (this.containerMenu != null) {
            this.containerMenu.removed(this);
        }
    }
}

