/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.ListTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Inventory
implements Container {
    public static final int POP_TIME_DURATION = 5;
    public static final int MAX_INVENTORY_STACK_SIZE = 64;
    private static final int INVENTORY_SIZE = 36;
    public ItemInstance[] items = new ItemInstance[36];
    public ItemInstance[] armor = new ItemInstance[4];
    public int selected = 0;
    private Player player;
    private ItemInstance carried;
    public boolean changed = false;

    public Inventory(Player player) {
        this.player = player;
    }

    public ItemInstance getSelected() {
        return this.items[this.selected];
    }

    private int getSlot(int n) {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null || this.items[i].id != n) continue;
            return i;
        }
        return -1;
    }

    private int getSlotWithRemainingSpace(ItemInstance itemInstance) {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null || this.items[i].id != itemInstance.id || !this.items[i].isStackable() || this.items[i].count >= this.items[i].getMaxStackSize() || this.items[i].count >= this.getMaxStackSize() || this.items[i].isStackedByData() && this.items[i].getAuxValue() != itemInstance.getAuxValue()) continue;
            return i;
        }
        return -1;
    }

    private int getFreeSlot() {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] != null) continue;
            return i;
        }
        return -1;
    }

    public void grabTexture(int n, boolean bl) {
        int n2 = this.getSlot(n);
        if (n2 >= 0 && n2 < 9) {
            this.selected = n2;
            return;
        }
    }

    public void swapPaint(int n) {
        if (n > 0) {
            n = 1;
        }
        if (n < 0) {
            n = -1;
        }
        this.selected -= n;
        while (this.selected < 0) {
            this.selected += 9;
        }
        while (this.selected >= 9) {
            this.selected -= 9;
        }
    }

    public void replaceSlot(int n) {
    }

    public void replaceSlot(Tile tile) {
        if (tile != null) {
            int n = this.getSlot(tile.id);
            if (n >= 0) {
                this.items[n] = this.items[this.selected];
            }
            this.items[this.selected] = new ItemInstance(Item.items[tile.id]);
        }
    }

    private int addResource(ItemInstance itemInstance) {
        int n;
        int n2 = itemInstance.id;
        int n3 = itemInstance.count;
        int n4 = this.getSlotWithRemainingSpace(itemInstance);
        if (n4 < 0) {
            n4 = this.getFreeSlot();
        }
        if (n4 < 0) {
            return n3;
        }
        if (this.items[n4] == null) {
            this.items[n4] = new ItemInstance(n2, 0, itemInstance.getAuxValue());
        }
        if ((n = n3) > this.items[n4].getMaxStackSize() - this.items[n4].count) {
            n = this.items[n4].getMaxStackSize() - this.items[n4].count;
        }
        if (n > this.getMaxStackSize() - this.items[n4].count) {
            n = this.getMaxStackSize() - this.items[n4].count;
        }
        if (n == 0) {
            return n3;
        }
        this.items[n4].count += n;
        this.items[n4].popTime = 5;
        return n3 -= n;
    }

    public void tick() {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null || this.items[i].popTime <= 0) continue;
            --this.items[i].popTime;
        }
    }

    public boolean removeResource(int n) {
        int n2 = this.getSlot(n);
        if (n2 < 0) {
            return false;
        }
        if (--this.items[n2].count <= 0) {
            this.items[n2] = null;
        }
        return true;
    }

    public void swapSlots(int n, int n2) {
        ItemInstance itemInstance = this.items[n2];
        this.items[n2] = this.items[n];
        this.items[n] = itemInstance;
    }

    public boolean add(ItemInstance itemInstance) {
        int n;
        if (!itemInstance.isDamaged()) {
            itemInstance.count = this.addResource(itemInstance);
            if (itemInstance.count == 0) {
                return true;
            }
        }
        if ((n = this.getFreeSlot()) >= 0) {
            this.items[n] = itemInstance;
            this.items[n].popTime = 5;
            return true;
        }
        return false;
    }

    @Override
    public ItemInstance removeItem(int n, int n2) {
        ItemInstance[] itemInstanceArray = this.items;
        if (n >= this.items.length) {
            itemInstanceArray = this.armor;
            n -= this.items.length;
        }
        if (itemInstanceArray[n] != null) {
            if (itemInstanceArray[n].count <= n2) {
                ItemInstance itemInstance = itemInstanceArray[n];
                itemInstanceArray[n] = null;
                return itemInstance;
            }
            ItemInstance itemInstance = itemInstanceArray[n].remove(n2);
            if (itemInstanceArray[n].count == 0) {
                itemInstanceArray[n] = null;
            }
            return itemInstance;
        }
        return null;
    }

    @Override
    public void setItem(int n, ItemInstance itemInstance) {
        ItemInstance[] itemInstanceArray = this.items;
        if (n >= itemInstanceArray.length) {
            n -= itemInstanceArray.length;
            itemInstanceArray = this.armor;
        }
        itemInstanceArray[n] = itemInstance;
    }

    public float getDestroySpeed(Tile tile) {
        float f = 1.0f;
        if (this.items[this.selected] != null) {
            f *= this.items[this.selected].getDestroySpeed(tile);
        }
        return f;
    }

    public ListTag<CompoundTag> save(ListTag<CompoundTag> listTag) {
        CompoundTag compoundTag;
        int n;
        for (n = 0; n < this.items.length; ++n) {
            if (this.items[n] == null) continue;
            compoundTag = new CompoundTag();
            compoundTag.putByte("Slot", (byte)n);
            this.items[n].save(compoundTag);
            listTag.add(compoundTag);
        }
        for (n = 0; n < this.armor.length; ++n) {
            if (this.armor[n] == null) continue;
            compoundTag = new CompoundTag();
            compoundTag.putByte("Slot", (byte)(n + 100));
            this.armor[n].save(compoundTag);
            listTag.add(compoundTag);
        }
        return listTag;
    }

    public void load(ListTag<CompoundTag> listTag) {
        this.items = new ItemInstance[36];
        this.armor = new ItemInstance[4];
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag compoundTag = listTag.get(i);
            int n = compoundTag.getByte("Slot") & 0xFF;
            ItemInstance itemInstance = new ItemInstance(compoundTag);
            if (itemInstance.getItem() == null) continue;
            if (n >= 0 && n < this.items.length) {
                this.items[n] = itemInstance;
            }
            if (n < 100 || n >= this.armor.length + 100) continue;
            this.armor[n - 100] = itemInstance;
        }
    }

    @Override
    public int getContainerSize() {
        return this.items.length + 4;
    }

    @Override
    public ItemInstance getItem(int n) {
        ItemInstance[] itemInstanceArray = this.items;
        if (n >= itemInstanceArray.length) {
            n -= itemInstanceArray.length;
            itemInstanceArray = this.armor;
        }
        return itemInstanceArray[n];
    }

    @Override
    public String getName() {
        return "Inventory";
    }

    @Override
    public int getMaxStackSize() {
        return 64;
    }

    public int getAttackDamage(Entity entity) {
        ItemInstance itemInstance = this.getItem(this.selected);
        if (itemInstance != null) {
            return itemInstance.getAttackDamage(entity);
        }
        return 1;
    }

    public boolean canDestroy(Tile tile) {
        if (tile.material != Material.stone && tile.material != Material.metal && tile.material != Material.snow && tile.material != Material.topSnow) {
            return true;
        }
        ItemInstance itemInstance = this.getItem(this.selected);
        if (itemInstance != null) {
            return itemInstance.canDestroySpecial(tile);
        }
        return false;
    }

    public ItemInstance getArmor(int n) {
        return this.armor[n];
    }

    public int getArmorValue() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.armor.length; ++i) {
            if (this.armor[i] == null || !(this.armor[i].getItem() instanceof ArmorItem)) continue;
            int n4 = this.armor[i].getMaxDamage();
            int n5 = this.armor[i].getDamageValue();
            int n6 = n4 - n5;
            n2 += n6;
            n3 += n4;
            int n7 = ((ArmorItem)this.armor[i].getItem()).defense;
            n += n7;
        }
        if (n3 == 0) {
            return 0;
        }
        return (n - 1) * n2 / n3 + 1;
    }

    public void hurtArmor(int n) {
        for (int i = 0; i < this.armor.length; ++i) {
            if (this.armor[i] == null || !(this.armor[i].getItem() instanceof ArmorItem)) continue;
            this.armor[i].hurt(n);
            if (this.armor[i].count != 0) continue;
            this.armor[i].snap(this.player);
            this.armor[i] = null;
        }
    }

    public void dropAll() {
        int n;
        for (n = 0; n < this.items.length; ++n) {
            if (this.items[n] == null) continue;
            this.player.drop(this.items[n], true);
            this.items[n] = null;
        }
        for (n = 0; n < this.armor.length; ++n) {
            if (this.armor[n] == null) continue;
            this.player.drop(this.armor[n], true);
            this.armor[n] = null;
        }
    }

    @Override
    public void setChanged() {
        this.changed = true;
    }

    public boolean isSame(Inventory inventory) {
        int n;
        for (n = 0; n < this.items.length; ++n) {
            if (this.isSame(inventory.items[n], this.items[n])) continue;
            return false;
        }
        for (n = 0; n < this.armor.length; ++n) {
            if (this.isSame(inventory.armor[n], this.armor[n])) continue;
            return false;
        }
        return true;
    }

    private boolean isSame(ItemInstance itemInstance, ItemInstance itemInstance2) {
        if (itemInstance == null && itemInstance2 == null) {
            return true;
        }
        if (itemInstance == null || itemInstance2 == null) {
            return false;
        }
        return itemInstance.id == itemInstance2.id && itemInstance.count == itemInstance2.count && itemInstance.getAuxValue() == itemInstance2.getAuxValue();
    }

    public Inventory copy() {
        int n;
        Inventory inventory = new Inventory(null);
        for (n = 0; n < this.items.length; ++n) {
            inventory.items[n] = this.items[n] != null ? this.items[n].copy() : null;
        }
        for (n = 0; n < this.armor.length; ++n) {
            inventory.armor[n] = this.armor[n] != null ? this.armor[n].copy() : null;
        }
        return inventory;
    }

    public void setCarried(ItemInstance itemInstance) {
        this.carried = itemInstance;
        this.player.carriedChanged(itemInstance);
    }

    public ItemInstance getCarried() {
        return this.carried;
    }

    @Override
    public boolean stillValid(Player player) {
        if (this.player.removed) {
            return false;
        }
        return !(player.distanceToSqr(this.player) > 64.0);
    }
}

