/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import util.Mth;

public class Zombie
extends Monster {
    public Zombie(Level level) {
        super(level);
        this.textureName = "/mob/zombie.png";
        this.runSpeed = 0.5f;
        this.attackDamage = 5;
    }

    public void aiStep() {
        float f;
        if (this.level.isDay() && (f = this.getBrightness(1.0f)) > 0.5f && this.level.canSeeSky(Mth.floor(this.x), Mth.floor(this.y), Mth.floor(this.z)) && this.random.nextFloat() * 30.0f < (f - 0.4f) * 2.0f) {
            this.onFire = 300;
        }
        super.aiStep();
    }

    protected String getAmbientSound() {
        return "mob.zombie";
    }

    protected String getHurtSound() {
        return "mob.zombiehurt";
    }

    protected String getDeathSound() {
        return "mob.zombiedeath";
    }

    protected int getDeathLoot() {
        return Item.feather.id;
    }
}

