/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.mojang.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import util.Mth;

public class Spider
extends Monster {
    public Spider(Level level) {
        super(level);
        this.textureName = "/mob/spider.png";
        this.setSize(1.4f, 0.9f);
        this.runSpeed = 0.8f;
    }

    public double getRideHeight() {
        return (double)this.bbHeight * 0.75 - 0.5;
    }

    protected Entity findAttackTarget() {
        float f = this.getBrightness(1.0f);
        if (f < 0.5f) {
            double d = 16.0;
            return this.level.getNearestPlayer(this, d);
        }
        return null;
    }

    protected String getAmbientSound() {
        return "mob.spider";
    }

    protected String getHurtSound() {
        return "mob.spider";
    }

    protected String getDeathSound() {
        return "mob.spiderdeath";
    }

    protected void checkHurtTarget(Entity entity, float f) {
        float f2 = this.getBrightness(1.0f);
        if (f2 > 0.5f && this.random.nextInt(100) == 0) {
            this.attackTarget = null;
            return;
        }
        if (f > 2.0f && f < 6.0f && this.random.nextInt(10) == 0) {
            if (this.onGround) {
                double d = entity.x - this.x;
                double d2 = entity.z - this.z;
                float f3 = Mth.sqrt(d * d + d2 * d2);
                this.xd = d / (double)f3 * 0.5 * (double)0.8f + this.xd * (double)0.2f;
                this.zd = d2 / (double)f3 * 0.5 * (double)0.8f + this.zd * (double)0.2f;
                this.yd = 0.4f;
            }
        } else {
            super.checkHurtTarget(entity, f);
        }
    }

    public void addAdditonalSaveData(CompoundTag compoundTag) {
        super.addAdditonalSaveData(compoundTag);
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
    }

    protected int getDeathLoot() {
        return Item.string.id;
    }

    public boolean onLadder() {
        return this.horizontalCollision;
    }
}

