/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.mojang.nbt.CompoundTag;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import util.Mth;

public class Slime
extends Mob
implements Enemy {
    public float squish;
    public float oSquish;
    private int jumpDelay = 0;
    public int size = 1;

    public Slime(Level level) {
        super(level);
        this.textureName = "/mob/slime.png";
        this.size = 1 << this.random.nextInt(3);
        this.heightOffset = 0.0f;
        this.jumpDelay = this.random.nextInt(20) + 10;
        this.setSize(this.size);
    }

    public void setSize(int n) {
        this.size = n;
        this.setSize(0.6f * (float)n, 0.6f * (float)n);
        this.health = n * n;
        this.setPos(this.x, this.y, this.z);
    }

    public void addAdditonalSaveData(CompoundTag compoundTag) {
        super.addAdditonalSaveData(compoundTag);
        compoundTag.putInt("Size", this.size - 1);
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.size = compoundTag.getInt("Size") + 1;
    }

    public void tick() {
        this.oSquish = this.squish;
        boolean bl = this.onGround;
        super.tick();
        if (this.onGround && !bl) {
            for (int i = 0; i < this.size * 8; ++i) {
                float f = this.random.nextFloat() * (float)Math.PI * 2.0f;
                float f2 = this.random.nextFloat() * 0.5f + 0.5f;
                float f3 = Mth.sin(f) * (float)this.size * 0.5f * f2;
                float f4 = Mth.cos(f) * (float)this.size * 0.5f * f2;
                this.level.addParticle("slime", this.x + (double)f3, this.bb.y0, this.z + (double)f4, 0.0, 0.0, 0.0);
            }
            if (this.size > 2) {
                this.level.playSound(this, "mob.slime", this.getSoundVolume(), ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            }
            this.squish = -0.5f;
        }
        this.squish *= 0.6f;
    }

    protected void updateAi() {
        Player player = this.level.getNearestPlayer(this, 16.0);
        if (player != null) {
            this.lookAt(player, 10.0f);
        }
        if (this.onGround && this.jumpDelay-- <= 0) {
            this.jumpDelay = this.random.nextInt(20) + 10;
            if (player != null) {
                this.jumpDelay /= 3;
            }
            this.jumping = true;
            if (this.size > 1) {
                this.level.playSound(this, "mob.slime", this.getSoundVolume(), ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
            this.squish = 1.0f;
            this.xxa = 1.0f - this.random.nextFloat() * 2.0f;
            this.yya = 1 * this.size;
        } else {
            this.jumping = false;
            if (this.onGround) {
                this.yya = 0.0f;
                this.xxa = 0.0f;
            }
        }
    }

    public void remove() {
        if (this.size > 1 && this.health == 0) {
            for (int i = 0; i < 4; ++i) {
                float f = ((float)(i % 2) - 0.5f) * (float)this.size / 4.0f;
                float f2 = ((float)(i / 2) - 0.5f) * (float)this.size / 4.0f;
                Slime slime = new Slime(this.level);
                slime.setSize(this.size / 2);
                slime.moveTo(this.x + (double)f, this.y + 0.5, this.z + (double)f2, this.random.nextFloat() * 360.0f, 0.0f);
                this.level.addEntity(slime);
            }
        }
        super.remove();
    }

    public void playerTouch(Player player) {
        if (this.size > 1 && this.canSee(player) && (double)this.distanceTo(player) < 0.6 * (double)this.size && player.hurt(this, this.size)) {
            this.level.playSound(this, "mob.slimeattack", 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
    }

    protected String getHurtSound() {
        return "mob.slime";
    }

    protected String getDeathSound() {
        return "mob.slime";
    }

    protected int getDeathLoot() {
        if (this.size == 1) {
            return Item.slimeBall.id;
        }
        return 0;
    }

    public boolean canSpawn() {
        LevelChunk levelChunk = this.level.getChunkAt(Mth.floor(this.x), Mth.floor(this.z));
        return (this.size == 1 || this.level.difficulty > 0) && this.random.nextInt(10) == 0 && levelChunk.getRandom(987234911L).nextInt(10) == 0 && this.y < 16.0;
    }

    protected float getSoundVolume() {
        return 0.6f;
    }
}

