/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.mojang.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;
import util.Mth;

public class Skeleton
extends Monster {
    private static final ItemInstance bow = new ItemInstance(Item.bow, 1);

    public Skeleton(Level level) {
        super(level);
        this.textureName = "/mob/skeleton.png";
    }

    protected String getAmbientSound() {
        return "mob.skeleton";
    }

    protected String getHurtSound() {
        return "mob.skeletonhurt";
    }

    protected String getDeathSound() {
        return "mob.skeletonhurt";
    }

    public void aiStep() {
        float f;
        if (this.level.isDay() && (f = this.getBrightness(1.0f)) > 0.5f && this.level.canSeeSky(Mth.floor(this.x), Mth.floor(this.y), Mth.floor(this.z)) && this.random.nextFloat() * 30.0f < (f - 0.4f) * 2.0f) {
            this.onFire = 300;
        }
        super.aiStep();
    }

    protected void checkHurtTarget(Entity entity, float f) {
        if (f < 10.0f) {
            double d = entity.x - this.x;
            double d2 = entity.z - this.z;
            if (this.attackTime == 0) {
                Arrow arrow = new Arrow(this.level, this);
                arrow.y += (double)1.4f;
                double d3 = entity.y - (double)0.2f - arrow.y;
                float f2 = Mth.sqrt(d * d + d2 * d2) * 0.2f;
                this.level.playSound(this, "random.bow", 1.0f, 1.0f / (this.random.nextFloat() * 0.4f + 0.8f));
                this.level.addEntity(arrow);
                arrow.shoot(d, d3 + (double)f2, d2, 0.6f, 12.0f);
                this.attackTime = 30;
            }
            this.yRot = (float)(Math.atan2(d2, d) * 180.0 / 3.1415927410125732) - 90.0f;
            this.holdGround = true;
        }
    }

    public void addAdditonalSaveData(CompoundTag compoundTag) {
        super.addAdditonalSaveData(compoundTag);
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
    }

    protected int getDeathLoot() {
        return Item.arrow.id;
    }

    protected void dropDeathLoot() {
        int n;
        int n2 = this.random.nextInt(3);
        for (n = 0; n < n2; ++n) {
            this.spawnAtLocation(Item.arrow.id, 1);
        }
        n2 = this.random.nextInt(3);
        for (n = 0; n < n2; ++n) {
            this.spawnAtLocation(Item.bone.id, 1);
        }
    }

    public ItemInstance getCarriedItem() {
        return bow;
    }
}

