/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.mojang.nbt.CompoundTag;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;

public class PigZombie
extends Zombie {
    private int angerTime = 0;
    private int playAngrySoundIn = 0;
    private static final ItemInstance sword = new ItemInstance(Item.sword_gold, 1);

    public PigZombie(Level level) {
        super(level);
        this.textureName = "/mob/pigzombie.png";
        this.runSpeed = 0.5f;
        this.attackDamage = 5;
        this.fireImmune = true;
    }

    public void tick() {
        float f = this.runSpeed = this.attackTarget != null ? 0.95f : 0.5f;
        if (this.playAngrySoundIn > 0 && --this.playAngrySoundIn == 0) {
            this.level.playSound(this, "mob.zombiepig.zpigangry", this.getSoundVolume() * 2.0f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) * 1.8f);
        }
        super.tick();
    }

    public boolean canSpawn() {
        return this.level.difficulty > 0 && this.level.isUnobstructed(this.bb) && this.level.getCubes(this, this.bb).size() == 0 && !this.level.containsAnyLiquid(this.bb);
    }

    public void addAdditonalSaveData(CompoundTag compoundTag) {
        super.addAdditonalSaveData(compoundTag);
        compoundTag.putShort("Anger", (short)this.angerTime);
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.angerTime = compoundTag.getShort("Anger");
    }

    protected Entity findAttackTarget() {
        if (this.angerTime == 0) {
            return null;
        }
        return super.findAttackTarget();
    }

    public void aiStep() {
        super.aiStep();
    }

    public boolean hurt(Entity entity, int n) {
        if (entity instanceof Player) {
            List<Entity> list = this.level.getEntities(this, this.bb.grow(32.0, 32.0, 32.0));
            for (int i = 0; i < list.size(); ++i) {
                Entity entity2 = list.get(i);
                if (!(entity2 instanceof PigZombie)) continue;
                PigZombie pigZombie = (PigZombie)entity2;
                pigZombie.alert(entity);
            }
            this.alert(entity);
        }
        return super.hurt(entity, n);
    }

    private void alert(Entity entity) {
        this.attackTarget = entity;
        this.angerTime = 400 + this.random.nextInt(400);
        this.playAngrySoundIn = this.random.nextInt(40);
    }

    protected String getAmbientSound() {
        return "mob.zombiepig.zpig";
    }

    protected String getHurtSound() {
        return "mob.zombiepig.zpighurt";
    }

    protected String getDeathSound() {
        return "mob.zombiepig.zpigdeath";
    }

    protected int getDeathLoot() {
        return Item.porkChop_cooked.id;
    }

    public ItemInstance getCarriedItem() {
        return sword;
    }
}

