/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.mojang.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import util.Mth;

public class Monster
extends PathfinderMob
implements Enemy {
    protected int attackDamage = 2;

    public Monster(Level level) {
        super(level);
        this.health = 20;
    }

    public void aiStep() {
        float f = this.getBrightness(1.0f);
        if (f > 0.5f) {
            this.noActionTime += 2;
        }
        super.aiStep();
    }

    public void tick() {
        super.tick();
        if (this.level.difficulty == 0) {
            this.remove();
        }
    }

    protected Entity findAttackTarget() {
        Player player = this.level.getNearestPlayer(this, 16.0);
        if (player != null && this.canSee(player)) {
            return player;
        }
        return null;
    }

    public boolean hurt(Entity entity, int n) {
        if (super.hurt(entity, n)) {
            if (this.rider == entity || this.riding == entity) {
                return true;
            }
            if (entity != this) {
                this.attackTarget = entity;
            }
            return true;
        }
        return false;
    }

    protected void checkHurtTarget(Entity entity, float f) {
        if ((double)f < 2.5 && entity.bb.y1 > this.bb.y0 && entity.bb.y0 < this.bb.y1) {
            this.attackTime = 20;
            entity.hurt(this, this.attackDamage);
        }
    }

    protected float getWalkTargetValue(int n, int n2, int n3) {
        return 0.5f - this.level.getBrightness(n, n2, n3);
    }

    public void addAdditonalSaveData(CompoundTag compoundTag) {
        super.addAdditonalSaveData(compoundTag);
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
    }

    public boolean canSpawn() {
        int n;
        int n2;
        int n3 = Mth.floor(this.x);
        if (this.level.getBrightness(LightLayer.Sky, n3, n2 = Mth.floor(this.bb.y0), n = Mth.floor(this.z)) > this.random.nextInt(32)) {
            return false;
        }
        int n4 = this.level.getRawBrightness(n3, n2, n);
        return n4 <= this.random.nextInt(8) && super.canSpawn();
    }
}

