/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import util.Mth;

public class Ghast
extends FlyingMob
implements Enemy {
    public int floatDuration = 0;
    public double xTarget;
    public double yTarget;
    public double zTarget;
    private Entity target = null;
    private int retargetTime = 0;
    public int oCharge = 0;
    public int charge = 0;

    public Ghast(Level level) {
        super(level);
        this.textureName = "/mob/ghast.png";
        this.setSize(4.0f, 4.0f);
        this.fireImmune = true;
    }

    protected void updateAi() {
        if (this.level.difficulty == 0) {
            this.remove();
        }
        this.oCharge = this.charge;
        double d = this.xTarget - this.x;
        double d2 = this.yTarget - this.y;
        double d3 = this.zTarget - this.z;
        double d4 = Mth.sqrt(d * d + d2 * d2 + d3 * d3);
        if (d4 < 1.0 || d4 > 60.0) {
            this.xTarget = this.x + (double)((this.random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.yTarget = this.y + (double)((this.random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.zTarget = this.z + (double)((this.random.nextFloat() * 2.0f - 1.0f) * 16.0f);
        }
        if (this.floatDuration-- <= 0) {
            this.floatDuration += this.random.nextInt(5) + 2;
            if (this.canReach(this.xTarget, this.yTarget, this.zTarget, d4)) {
                this.xd += d / d4 * 0.1;
                this.yd += d2 / d4 * 0.1;
                this.zd += d3 / d4 * 0.1;
            } else {
                this.xTarget = this.x;
                this.yTarget = this.y;
                this.zTarget = this.z;
            }
        }
        if (this.target != null && this.target.removed) {
            this.target = null;
        }
        if (this.target == null || this.retargetTime-- <= 0) {
            this.target = this.level.getNearestPlayer(this, 100.0);
            if (this.target != null) {
                this.retargetTime = 20;
            }
        }
        double d5 = 64.0;
        if (this.target != null && this.target.distanceToSqr(this) < d5 * d5) {
            double d6 = this.target.x - this.x;
            double d7 = this.target.bb.y0 + (double)(this.target.bbHeight / 2.0f) - (this.y + (double)(this.bbHeight / 2.0f));
            double d8 = this.target.z - this.z;
            this.yBodyRot = this.yRot = -((float)Math.atan2(d6, d8)) * 180.0f / (float)Math.PI;
            if (this.canSee(this.target)) {
                if (this.charge == 10) {
                    this.level.playSound(this, "mob.ghast.charge", this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                }
                ++this.charge;
                if (this.charge == 20) {
                    this.level.playSound(this, "mob.ghast.fireball", this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                    Fireball fireball = new Fireball(this.level, this, d6, d7, d8);
                    double d9 = 4.0;
                    Vec3 vec3 = this.getViewVector(1.0f);
                    fireball.x = this.x + vec3.x * d9;
                    fireball.y = this.y + (double)(this.bbHeight / 2.0f) + 0.5;
                    fireball.z = this.z + vec3.z * d9;
                    this.level.addEntity(fireball);
                    this.charge = -40;
                }
            } else if (this.charge > 0) {
                --this.charge;
            }
        } else {
            this.yBodyRot = this.yRot = -((float)Math.atan2(this.xd, this.zd)) * 180.0f / (float)Math.PI;
            if (this.charge > 0) {
                --this.charge;
            }
        }
        this.textureName = this.charge > 10 ? "/mob/ghast_fire.png" : "/mob/ghast.png";
    }

    private boolean canReach(double d, double d2, double d3, double d4) {
        double d5 = (this.xTarget - this.x) / d4;
        double d6 = (this.yTarget - this.y) / d4;
        double d7 = (this.zTarget - this.z) / d4;
        AABB aABB = this.bb.copy();
        int n = 1;
        while ((double)n < d4) {
            aABB.move(d5, d6, d7);
            if (this.level.getCubes(this, aABB).size() > 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected String getAmbientSound() {
        return "mob.ghast.moan";
    }

    protected String getHurtSound() {
        return "mob.ghast.scream";
    }

    protected String getDeathSound() {
        return "mob.ghast.death";
    }

    protected void checkHurtTarget(Entity entity, float f) {
    }

    protected int getDeathLoot() {
        return Item.sulphur.id;
    }

    protected float getSoundVolume() {
        return 10.0f;
    }

    public boolean canSpawn() {
        return this.random.nextInt(20) == 0 && super.canSpawn() && this.level.difficulty > 0;
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }
}

