/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.mojang.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class Creeper
extends Monster {
    private static final int DATA_SWELL_DIR = 16;
    int swell;
    int oldSwell;
    private static final int MAX_SWELL = 30;

    public Creeper(Level level) {
        super(level);
        this.textureName = "/mob/creeper.png";
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(16, (byte)-1);
    }

    public void addAdditonalSaveData(CompoundTag compoundTag) {
        super.addAdditonalSaveData(compoundTag);
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
    }

    public void tick() {
        this.oldSwell = this.swell;
        if (this.level.isOnline) {
            int n = this.getSwellDir();
            if (n > 0 && this.swell == 0) {
                this.level.playSound(this, "random.fuse", 1.0f, 0.5f);
            }
            this.swell += n;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= 30) {
                this.swell = 30;
            }
        }
        super.tick();
    }

    protected String getHurtSound() {
        return "mob.creeper";
    }

    protected String getDeathSound() {
        return "mob.creeperdeath";
    }

    public void die(Entity entity) {
        super.die(entity);
        if (entity instanceof Skeleton) {
            this.spawnAtLocation(Item.record_01.id + this.random.nextInt(2), 1);
        }
    }

    protected void checkHurtTarget(Entity entity, float f) {
        int n = this.getSwellDir();
        if (n <= 0 && f < 3.0f || n > 0 && f < 7.0f) {
            if (this.swell == 0) {
                this.level.playSound(this, "random.fuse", 1.0f, 0.5f);
            }
            this.setSwellDir(1);
            ++this.swell;
            if (this.swell >= 30) {
                this.level.explode(this, this.x, this.y, this.z, 3.0f);
                this.remove();
            }
            this.holdGround = true;
        } else {
            this.setSwellDir(-1);
            --this.swell;
            if (this.swell < 0) {
                this.swell = 0;
            }
        }
    }

    public float getSwelling(float f) {
        return ((float)this.oldSwell + (float)(this.swell - this.oldSwell) * f) / 28.0f;
    }

    protected int getDeathLoot() {
        return Item.sulphur.id;
    }

    private int getSwellDir() {
        return this.entityData.getByte(16);
    }

    private void setSwellDir(int n) {
        this.entityData.set(16, (byte)n);
    }
}

