/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import util.Mth;

public class PrimedTnt
extends Entity {
    public static final long serialVersionUID = 0L;
    public int life = 0;

    public PrimedTnt(Level level) {
        super(level);
        this.blocksBuilding = true;
        this.setSize(0.98f, 0.98f);
        this.heightOffset = this.bbHeight / 2.0f;
    }

    public PrimedTnt(Level level, double d, double d2, double d3) {
        this(level);
        this.setPos(d, d2, d3);
        float f = (float)(Math.random() * 3.1415927410125732 * 2.0);
        this.xd = -Mth.sin(f * (float)Math.PI / 180.0f) * 0.02f;
        this.yd = 0.2f;
        this.zd = -Mth.cos(f * (float)Math.PI / 180.0f) * 0.02f;
        this.makeStepSound = false;
        this.life = 80;
        this.xo = d;
        this.yo = d2;
        this.zo = d3;
    }

    protected void defineSynchedData() {
    }

    public boolean isPickable() {
        return !this.removed;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.yd -= (double)0.04f;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= (double)0.98f;
        this.yd *= (double)0.98f;
        this.zd *= (double)0.98f;
        if (this.onGround) {
            this.xd *= (double)0.7f;
            this.zd *= (double)0.7f;
            this.yd *= -0.5;
        }
        if (this.life-- <= 0) {
            this.remove();
            this.explode();
        } else {
            this.level.addParticle("smoke", this.x, this.y + 0.5, this.z, 0.0, 0.0, 0.0);
        }
    }

    private void explode() {
        float f = 4.0f;
        this.level.explode(null, this.x, this.y, this.z, f);
    }

    protected void addAdditonalSaveData(CompoundTag compoundTag) {
        compoundTag.putByte("Fuse", (byte)this.life);
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        this.life = compoundTag.getByte("Fuse");
    }

    public float getShadowHeightOffs() {
        return 0.0f;
    }
}

