/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.ListTag;
import com.mojang.nbt.Tag;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import util.Mth;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Minecart
extends Entity
implements Container {
    public static final int RIDEABLE = 0;
    public static final int CHEST = 1;
    public static final int FURNACE = 2;
    private ItemInstance[] items = new ItemInstance[36];
    public static final long serialVersionUID = 0L;
    public int damage = 0;
    public int hurtTime = 0;
    public int hurtDir = 1;
    private boolean flipped = false;
    public int type;
    public int fuel;
    public double xPush;
    public double zPush;
    private static final int[][][] EXITS = new int[][][]{new int[][]{{0, 0, -1}, {0, 0, 1}}, new int[][]{{-1, 0, 0}, {1, 0, 0}}, new int[][]{{-1, -1, 0}, {1, 0, 0}}, new int[][]{{-1, 0, 0}, {1, -1, 0}}, new int[][]{{0, 0, -1}, {0, -1, 1}}, new int[][]{{0, -1, -1}, {0, 0, 1}}, new int[][]{{0, 0, 1}, {1, 0, 0}}, new int[][]{{0, 0, 1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {1, 0, 0}}};
    private int lSteps;
    private double lx;
    private double ly;
    private double lz;
    private double lyr;
    private double lxr;
    private double lxd;
    private double lyd;
    private double lzd;

    public Minecart(Level level) {
        super(level);
        this.blocksBuilding = true;
        this.setSize(0.98f, 0.7f);
        this.heightOffset = this.bbHeight / 2.0f;
        this.makeStepSound = false;
    }

    @Override
    protected void defineSynchedData() {
    }

    @Override
    public AABB getCollideAgainstBox(Entity entity) {
        return entity.bb;
    }

    @Override
    public AABB getCollideBox() {
        return null;
    }

    @Override
    public boolean isPushable() {
        return true;
    }

    public Minecart(Level level, double d, double d2, double d3, int n) {
        this(level);
        this.setPos(d, d2 + (double)this.heightOffset, d3);
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.xo = d;
        this.yo = d2;
        this.zo = d3;
        this.type = n;
    }

    @Override
    public double getRideHeight() {
        return (double)this.bbHeight * 0.0 - (double)0.3f;
    }

    @Override
    public boolean hurt(Entity entity, int n) {
        if (this.level.isOnline || this.removed) {
            return true;
        }
        this.hurtDir = -this.hurtDir;
        this.hurtTime = 10;
        this.markHurt();
        this.damage += n * 10;
        if (this.damage > 40) {
            this.spawnAtLocation(Item.minecart.id, 1, 0.0f);
            if (this.type == 1) {
                this.spawnAtLocation(Tile.chest.id, 1, 0.0f);
            } else if (this.type == 2) {
                this.spawnAtLocation(Tile.furnace.id, 1, 0.0f);
            }
            this.remove();
        }
        return true;
    }

    @Override
    public void animateHurt() {
        System.out.println("Animating hurt");
        this.hurtDir = -this.hurtDir;
        this.hurtTime = 10;
        this.damage += this.damage * 10;
    }

    @Override
    public boolean isPickable() {
        return !this.removed;
    }

    @Override
    public void remove() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemInstance itemInstance = this.getItem(i);
            if (itemInstance == null) continue;
            float f = this.random.nextFloat() * 0.8f + 0.1f;
            float f2 = this.random.nextFloat() * 0.8f + 0.1f;
            float f3 = this.random.nextFloat() * 0.8f + 0.1f;
            while (itemInstance.count > 0) {
                int n = this.random.nextInt(21) + 10;
                if (n > itemInstance.count) {
                    n = itemInstance.count;
                }
                itemInstance.count -= n;
                ItemEntity itemEntity = new ItemEntity(this.level, this.x + (double)f, this.y + (double)f2, this.z + (double)f3, new ItemInstance(itemInstance.id, n, itemInstance.getAuxValue()));
                float f4 = 0.05f;
                itemEntity.xd = (float)this.random.nextGaussian() * f4;
                itemEntity.yd = (float)this.random.nextGaussian() * f4 + 0.2f;
                itemEntity.zd = (float)this.random.nextGaussian() * f4;
                this.level.addEntity(itemEntity);
            }
        }
        super.remove();
    }

    @Override
    public void tick() {
        double d;
        int n;
        int n2;
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        if (this.damage > 0) {
            --this.damage;
        }
        if (this.level.isOnline && this.lSteps > 0) {
            if (this.lSteps > 0) {
                double d2;
                double d3 = this.x + (this.lx - this.x) / (double)this.lSteps;
                double d4 = this.y + (this.ly - this.y) / (double)this.lSteps;
                double d5 = this.z + (this.lz - this.z) / (double)this.lSteps;
                for (d2 = this.lyr - (double)this.yRot; d2 < -180.0; d2 += 360.0) {
                }
                while (d2 >= 180.0) {
                    d2 -= 360.0;
                }
                this.yRot = (float)((double)this.yRot + d2 / (double)this.lSteps);
                this.xRot = (float)((double)this.xRot + (this.lxr - (double)this.xRot) / (double)this.lSteps);
                --this.lSteps;
                this.setPos(d3, d4, d5);
                this.setRot(this.yRot, this.xRot);
            } else {
                this.setPos(this.x, this.y, this.z);
                this.setRot(this.yRot, this.xRot);
            }
            return;
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.yd -= (double)0.04f;
        int n3 = Mth.floor(this.x);
        if (this.level.getTile(n3, (n2 = Mth.floor(this.y)) - 1, n = Mth.floor(this.z)) == Tile.rail.id) {
            --n2;
        }
        double d6 = 0.4;
        boolean bl = false;
        double d7 = 0.0078125;
        if (this.level.getTile(n3, n2, n) == Tile.rail.id) {
            double d8;
            double d9;
            double d10;
            double d11;
            Vec3 vec3 = this.getPos(this.x, this.y, this.z);
            int n4 = this.level.getData(n3, n2, n);
            this.y = n2;
            if (n4 >= 2 && n4 <= 5) {
                this.y = n2 + 1;
            }
            if (n4 == 2) {
                this.xd -= d7;
            }
            if (n4 == 3) {
                this.xd += d7;
            }
            if (n4 == 4) {
                this.zd += d7;
            }
            if (n4 == 5) {
                this.zd -= d7;
            }
            int[][] nArray = EXITS[n4];
            double d12 = nArray[1][0] - nArray[0][0];
            double d13 = nArray[1][2] - nArray[0][2];
            double d14 = Math.sqrt(d12 * d12 + d13 * d13);
            double d15 = this.xd * d12 + this.zd * d13;
            if (d15 < 0.0) {
                d12 = -d12;
                d13 = -d13;
            }
            double d16 = Math.sqrt(this.xd * this.xd + this.zd * this.zd);
            this.xd = d16 * d12 / d14;
            this.zd = d16 * d13 / d14;
            double d17 = 0.0;
            double d18 = (double)n3 + 0.5 + (double)nArray[0][0] * 0.5;
            double d19 = (double)n + 0.5 + (double)nArray[0][2] * 0.5;
            double d20 = (double)n3 + 0.5 + (double)nArray[1][0] * 0.5;
            double d21 = (double)n + 0.5 + (double)nArray[1][2] * 0.5;
            d12 = d20 - d18;
            d13 = d21 - d19;
            if (d12 == 0.0) {
                this.x = (double)n3 + 0.5;
                d17 = this.z - (double)n;
            } else if (d13 == 0.0) {
                this.z = (double)n + 0.5;
                d17 = this.x - (double)n3;
            } else {
                d11 = this.x - d18;
                d10 = this.z - d19;
                d17 = d9 = (d11 * d12 + d10 * d13) * 2.0;
            }
            this.x = d18 + d12 * d17;
            this.z = d19 + d13 * d17;
            this.setPos(this.x, this.y + (double)this.heightOffset, this.z);
            d11 = this.xd;
            d10 = this.zd;
            if (this.rider != null) {
                d11 *= 0.75;
                d10 *= 0.75;
            }
            if (d11 < -d6) {
                d11 = -d6;
            }
            if (d11 > d6) {
                d11 = d6;
            }
            if (d10 < -d6) {
                d10 = -d6;
            }
            if (d10 > d6) {
                d10 = d6;
            }
            this.move(d11, 0.0, d10);
            if (nArray[0][1] != 0 && Mth.floor(this.x) - n3 == nArray[0][0] && Mth.floor(this.z) - n == nArray[0][2]) {
                this.setPos(this.x, this.y + (double)nArray[0][1], this.z);
            } else if (nArray[1][1] != 0 && Mth.floor(this.x) - n3 == nArray[1][0] && Mth.floor(this.z) - n == nArray[1][2]) {
                this.setPos(this.x, this.y + (double)nArray[1][1], this.z);
            }
            if (this.rider != null) {
                this.xd *= (double)0.997f;
                this.yd *= 0.0;
                this.zd *= (double)0.997f;
            } else {
                if (this.type == 2) {
                    d9 = Mth.sqrt(this.xPush * this.xPush + this.zPush * this.zPush);
                    if (d9 > 0.01) {
                        bl = true;
                        this.xPush /= d9;
                        this.zPush /= d9;
                        double d22 = 0.04;
                        this.xd *= (double)0.8f;
                        this.yd *= 0.0;
                        this.zd *= (double)0.8f;
                        this.xd += this.xPush * d22;
                        this.zd += this.zPush * d22;
                    } else {
                        this.xd *= (double)0.9f;
                        this.yd *= 0.0;
                        this.zd *= (double)0.9f;
                    }
                }
                this.xd *= (double)0.96f;
                this.yd *= 0.0;
                this.zd *= (double)0.96f;
            }
            Vec3 vec32 = this.getPos(this.x, this.y, this.z);
            if (vec32 != null && vec3 != null) {
                double d23 = (vec3.y - vec32.y) * 0.05;
                d16 = Math.sqrt(this.xd * this.xd + this.zd * this.zd);
                if (d16 > 0.0) {
                    this.xd = this.xd / d16 * (d16 + d23);
                    this.zd = this.zd / d16 * (d16 + d23);
                }
                this.setPos(this.x, vec32.y, this.z);
            }
            int n5 = Mth.floor(this.x);
            int n6 = Mth.floor(this.z);
            if (n5 != n3 || n6 != n) {
                d16 = Math.sqrt(this.xd * this.xd + this.zd * this.zd);
                this.xd = d16 * (double)(n5 - n3);
                this.zd = d16 * (double)(n6 - n);
            }
            if (this.type == 2 && (d8 = (double)Mth.sqrt(this.xPush * this.xPush + this.zPush * this.zPush)) > 0.01 && this.xd * this.xd + this.zd * this.zd > 0.001) {
                this.xPush /= d8;
                this.zPush /= d8;
                if (this.xPush * this.xd + this.zPush * this.zd < 0.0) {
                    this.xPush = 0.0;
                    this.zPush = 0.0;
                } else {
                    this.xPush = this.xd;
                    this.zPush = this.zd;
                }
            }
        } else {
            if (this.xd < -d6) {
                this.xd = -d6;
            }
            if (this.xd > d6) {
                this.xd = d6;
            }
            if (this.zd < -d6) {
                this.zd = -d6;
            }
            if (this.zd > d6) {
                this.zd = d6;
            }
            if (this.onGround) {
                this.xd *= 0.5;
                this.yd *= 0.5;
                this.zd *= 0.5;
            }
            this.move(this.xd, this.yd, this.zd);
            if (!this.onGround) {
                this.xd *= (double)0.95f;
                this.yd *= (double)0.95f;
                this.zd *= (double)0.95f;
            }
        }
        this.xRot = 0.0f;
        double d24 = this.xo - this.x;
        double d25 = this.zo - this.z;
        if (d24 * d24 + d25 * d25 > 0.001) {
            this.yRot = (float)(Math.atan2(d25, d24) * 180.0 / Math.PI);
            if (this.flipped) {
                this.yRot += 180.0f;
            }
        }
        for (d = (double)(this.yRot - this.yRotO); d >= 180.0; d -= 360.0) {
        }
        while (d < -180.0) {
            d += 360.0;
        }
        if (d < -170.0 || d >= 170.0) {
            this.yRot += 180.0f;
            this.flipped = !this.flipped;
        }
        this.setRot(this.yRot, this.xRot);
        List<Entity> list = this.level.getEntities(this, this.bb.grow(0.2f, 0.0, 0.2f));
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = list.get(i);
                if (entity == this.rider || !entity.isPushable() || !(entity instanceof Minecart)) continue;
                entity.push(this);
            }
        }
        if (this.rider != null && this.rider.removed) {
            this.rider = null;
        }
        if (bl && this.random.nextInt(4) == 0) {
            --this.fuel;
            if (this.fuel < 0) {
                this.zPush = 0.0;
                this.xPush = 0.0;
            }
            this.level.addParticle("largesmoke", this.x, this.y + 0.8, this.z, 0.0, 0.0, 0.0);
        }
    }

    public Vec3 getPosOffs(double d, double d2, double d3, double d4) {
        int n;
        int n2;
        int n3 = Mth.floor(d);
        if (this.level.getTile(n3, (n2 = Mth.floor(d2)) - 1, n = Mth.floor(d3)) == Tile.rail.id) {
            --n2;
        }
        if (this.level.getTile(n3, n2, n) == Tile.rail.id) {
            int n4 = this.level.getData(n3, n2, n);
            d2 = n2;
            if (n4 >= 2 && n4 <= 5) {
                d2 = n2 + 1;
            }
            int[][] nArray = EXITS[n4];
            double d5 = nArray[1][0] - nArray[0][0];
            double d6 = nArray[1][2] - nArray[0][2];
            double d7 = Math.sqrt(d5 * d5 + d6 * d6);
            if (nArray[0][1] != 0 && Mth.floor(d += (d5 /= d7) * d4) - n3 == nArray[0][0] && Mth.floor(d3 += (d6 /= d7) * d4) - n == nArray[0][2]) {
                d2 += (double)nArray[0][1];
            } else if (nArray[1][1] != 0 && Mth.floor(d) - n3 == nArray[1][0] && Mth.floor(d3) - n == nArray[1][2]) {
                d2 += (double)nArray[1][1];
            }
            return this.getPos(d, d2, d3);
        }
        return null;
    }

    public Vec3 getPos(double d, double d2, double d3) {
        int n;
        int n2;
        int n3 = Mth.floor(d);
        if (this.level.getTile(n3, (n2 = Mth.floor(d2)) - 1, n = Mth.floor(d3)) == Tile.rail.id) {
            --n2;
        }
        if (this.level.getTile(n3, n2, n) == Tile.rail.id) {
            int n4 = this.level.getData(n3, n2, n);
            d2 = n2;
            if (n4 >= 2 && n4 <= 5) {
                d2 = n2 + 1;
            }
            int[][] nArray = EXITS[n4];
            double d4 = 0.0;
            double d5 = (double)n3 + 0.5 + (double)nArray[0][0] * 0.5;
            double d6 = (double)n2 + 0.5 + (double)nArray[0][1] * 0.5;
            double d7 = (double)n + 0.5 + (double)nArray[0][2] * 0.5;
            double d8 = (double)n3 + 0.5 + (double)nArray[1][0] * 0.5;
            double d9 = (double)n2 + 0.5 + (double)nArray[1][1] * 0.5;
            double d10 = (double)n + 0.5 + (double)nArray[1][2] * 0.5;
            double d11 = d8 - d5;
            double d12 = (d9 - d6) * 2.0;
            double d13 = d10 - d7;
            if (d11 == 0.0) {
                d = (double)n3 + 0.5;
                d4 = d3 - (double)n;
            } else if (d13 == 0.0) {
                d3 = (double)n + 0.5;
                d4 = d - (double)n3;
            } else {
                double d14;
                double d15 = d - d5;
                double d16 = d3 - d7;
                d4 = d14 = (d15 * d11 + d16 * d13) * 2.0;
            }
            d = d5 + d11 * d4;
            d2 = d6 + d12 * d4;
            d3 = d7 + d13 * d4;
            if (d12 < 0.0) {
                d2 += 1.0;
            }
            if (d12 > 0.0) {
                d2 += 0.5;
            }
            return Vec3.newTemp(d, d2, d3);
        }
        return null;
    }

    @Override
    protected void addAdditonalSaveData(CompoundTag compoundTag) {
        compoundTag.putInt("Type", this.type);
        if (this.type == 2) {
            compoundTag.putDouble("PushX", this.xPush);
            compoundTag.putDouble("PushZ", this.zPush);
            compoundTag.putShort("Fuel", (short)this.fuel);
        } else if (this.type == 1) {
            ListTag<CompoundTag> listTag = new ListTag<CompoundTag>();
            for (int i = 0; i < this.items.length; ++i) {
                if (this.items[i] == null) continue;
                CompoundTag compoundTag2 = new CompoundTag();
                compoundTag2.putByte("Slot", (byte)i);
                this.items[i].save(compoundTag2);
                listTag.add(compoundTag2);
            }
            compoundTag.put("Items", listTag);
        }
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        this.type = compoundTag.getInt("Type");
        if (this.type == 2) {
            this.xPush = compoundTag.getDouble("PushX");
            this.zPush = compoundTag.getDouble("PushZ");
            this.fuel = compoundTag.getShort("Fuel");
        } else if (this.type == 1) {
            ListTag<? extends Tag> listTag = compoundTag.getList("Items");
            this.items = new ItemInstance[this.getContainerSize()];
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag compoundTag2 = (CompoundTag)listTag.get(i);
                int n = compoundTag2.getByte("Slot") & 0xFF;
                if (n < 0 || n >= this.items.length) continue;
                this.items[n] = new ItemInstance(compoundTag2);
            }
        }
    }

    @Override
    public float getShadowHeightOffs() {
        return 0.0f;
    }

    @Override
    public void push(Entity entity) {
        double d;
        double d2;
        double d3;
        if (this.level.isOnline) {
            return;
        }
        if (entity == this.rider) {
            return;
        }
        if (entity instanceof Mob && !(entity instanceof Player) && this.type == 0 && this.xd * this.xd + this.zd * this.zd > 0.01 && this.rider == null && entity.riding == null) {
            entity.ride(this);
        }
        if ((d3 = (d2 = entity.x - this.x) * d2 + (d = entity.z - this.z) * d) >= (double)1.0E-4f) {
            d3 = Mth.sqrt(d3);
            d2 /= d3;
            d /= d3;
            double d4 = 1.0 / d3;
            if (d4 > 1.0) {
                d4 = 1.0;
            }
            d2 *= d4;
            d *= d4;
            d2 *= (double)0.1f;
            d *= (double)0.1f;
            d2 *= (double)(1.0f - this.pushthrough);
            d *= (double)(1.0f - this.pushthrough);
            d2 *= 0.5;
            d *= 0.5;
            if (entity instanceof Minecart) {
                double d5 = entity.xd + this.xd;
                double d6 = entity.zd + this.zd;
                if (((Minecart)entity).type == 2 && this.type != 2) {
                    this.xd *= (double)0.2f;
                    this.zd *= (double)0.2f;
                    this.push(entity.xd - d2, 0.0, entity.zd - d);
                    entity.xd *= (double)0.7f;
                    entity.zd *= (double)0.7f;
                } else if (((Minecart)entity).type != 2 && this.type == 2) {
                    entity.xd *= (double)0.2f;
                    entity.zd *= (double)0.2f;
                    entity.push(this.xd + d2, 0.0, this.zd + d);
                    this.xd *= (double)0.7f;
                    this.zd *= (double)0.7f;
                } else {
                    this.xd *= (double)0.2f;
                    this.zd *= (double)0.2f;
                    this.push((d5 /= 2.0) - d2, 0.0, (d6 /= 2.0) - d);
                    entity.xd *= (double)0.2f;
                    entity.zd *= (double)0.2f;
                    entity.push(d5 + d2, 0.0, d6 + d);
                }
            } else {
                this.push(-d2, 0.0, -d);
                entity.push(d2 / 4.0, 0.0, d / 4.0);
            }
        }
    }

    @Override
    public int getContainerSize() {
        return 27;
    }

    @Override
    public ItemInstance getItem(int n) {
        return this.items[n];
    }

    @Override
    public ItemInstance removeItem(int n, int n2) {
        if (this.items[n] != null) {
            if (this.items[n].count <= n2) {
                ItemInstance itemInstance = this.items[n];
                this.items[n] = null;
                return itemInstance;
            }
            ItemInstance itemInstance = this.items[n].remove(n2);
            if (this.items[n].count == 0) {
                this.items[n] = null;
            }
            return itemInstance;
        }
        return null;
    }

    @Override
    public void setItem(int n, ItemInstance itemInstance) {
        this.items[n] = itemInstance;
        if (itemInstance != null && itemInstance.count > this.getMaxStackSize()) {
            itemInstance.count = this.getMaxStackSize();
        }
    }

    @Override
    public String getName() {
        return "Minecart";
    }

    public void load(ListTag<CompoundTag> listTag) {
    }

    @Override
    public int getMaxStackSize() {
        return 64;
    }

    @Override
    public void setChanged() {
    }

    @Override
    public boolean interact(Player player) {
        if (this.type == 0) {
            if (this.rider != null && this.rider instanceof Player && this.rider != player) {
                return true;
            }
            if (!this.level.isOnline) {
                player.ride(this);
            }
        } else if (this.type == 1) {
            if (!this.level.isOnline) {
                player.openContainer(this);
            }
        } else if (this.type == 2) {
            ItemInstance itemInstance = player.inventory.getSelected();
            if (itemInstance != null && itemInstance.id == Item.coal.id) {
                if (--itemInstance.count == 0) {
                    player.inventory.setItem(player.inventory.selected, null);
                }
                this.fuel += 1200;
            }
            this.xPush = this.x - player.x;
            this.zPush = this.z - player.z;
        }
        return true;
    }

    public float getLootContent() {
        int n = 0;
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            ++n;
        }
        return (float)n / (float)this.items.length;
    }

    @Override
    public void lerpTo(double d, double d2, double d3, float f, float f2, int n) {
        this.lx = d;
        this.ly = d2;
        this.lz = d3;
        this.lyr = f;
        this.lxr = f2;
        this.lSteps = n + 2;
        this.xd = this.lxd;
        this.yd = this.lyd;
        this.zd = this.lzd;
    }

    @Override
    public void lerpMotion(double d, double d2, double d3) {
        this.lxd = this.xd = d;
        this.lyd = this.yd = d2;
        this.lzd = this.zd = d3;
    }

    @Override
    public boolean stillValid(Player player) {
        if (this.removed) {
            return false;
        }
        return !(player.distanceToSqr(this) > 64.0);
    }
}

