/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;
import util.Mth;

public class ItemEntity
extends Entity {
    private static final int LIFETIME = 6000;
    public ItemInstance item;
    private int tickCount;
    public int age = 0;
    public int throwTime;
    private int health = 5;
    public float bobOffs = (float)(Math.random() * Math.PI * 2.0);

    public ItemEntity(Level level, double d, double d2, double d3, ItemInstance itemInstance) {
        super(level);
        this.setSize(0.25f, 0.25f);
        this.heightOffset = this.bbHeight / 2.0f;
        this.setPos(d, d2, d3);
        this.item = itemInstance;
        this.yRot = (float)(Math.random() * 360.0);
        this.xd = (float)(Math.random() * (double)0.2f - (double)0.1f);
        this.yd = 0.2f;
        this.zd = (float)(Math.random() * (double)0.2f - (double)0.1f);
        this.makeStepSound = false;
    }

    public ItemEntity(Level level) {
        super(level);
        this.setSize(0.25f, 0.25f);
        this.heightOffset = this.bbHeight / 2.0f;
    }

    protected void defineSynchedData() {
    }

    public void tick() {
        super.tick();
        if (this.throwTime > 0) {
            --this.throwTime;
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.yd -= (double)0.04f;
        if (this.level.getMaterial(Mth.floor(this.x), Mth.floor(this.y), Mth.floor(this.z)) == Material.lava) {
            this.yd = 0.2f;
            this.xd = (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
            this.zd = (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
            this.level.playSound(this, "random.fizz", 0.4f, 2.0f + this.random.nextFloat() * 0.4f);
        }
        this.checkInTile(this.x, this.y, this.z);
        this.move(this.xd, this.yd, this.zd);
        float f = 0.98f;
        if (this.onGround) {
            f = 0.58800006f;
            int n = this.level.getTile(Mth.floor(this.x), Mth.floor(this.bb.y0) - 1, Mth.floor(this.z));
            if (n > 0) {
                f = Tile.tiles[n].friction * 0.98f;
            }
        }
        this.xd *= (double)f;
        this.yd *= (double)0.98f;
        this.zd *= (double)f;
        if (this.onGround) {
            this.yd *= -0.5;
        }
        ++this.tickCount;
        ++this.age;
        if (this.age >= 6000) {
            this.remove();
        }
    }

    public boolean isInWater() {
        return this.level.checkAndHandleWater(this.bb, Material.water, this);
    }

    private boolean checkInTile(double d, double d2, double d3) {
        int n = Mth.floor(d);
        int n2 = Mth.floor(d2);
        int n3 = Mth.floor(d3);
        double d4 = d - (double)n;
        double d5 = d2 - (double)n2;
        double d6 = d3 - (double)n3;
        if (Tile.solid[this.level.getTile(n, n2, n3)]) {
            boolean bl = !Tile.solid[this.level.getTile(n - 1, n2, n3)];
            boolean bl2 = !Tile.solid[this.level.getTile(n + 1, n2, n3)];
            boolean bl3 = !Tile.solid[this.level.getTile(n, n2 - 1, n3)];
            boolean bl4 = !Tile.solid[this.level.getTile(n, n2 + 1, n3)];
            boolean bl5 = !Tile.solid[this.level.getTile(n, n2, n3 - 1)];
            boolean bl6 = !Tile.solid[this.level.getTile(n, n2, n3 + 1)];
            int n4 = -1;
            double d7 = 9999.0;
            if (bl && d4 < d7) {
                d7 = d4;
                n4 = 0;
            }
            if (bl2 && 1.0 - d4 < d7) {
                d7 = 1.0 - d4;
                n4 = 1;
            }
            if (bl3 && d5 < d7) {
                d7 = d5;
                n4 = 2;
            }
            if (bl4 && 1.0 - d5 < d7) {
                d7 = 1.0 - d5;
                n4 = 3;
            }
            if (bl5 && d6 < d7) {
                d7 = d6;
                n4 = 4;
            }
            if (bl6 && 1.0 - d6 < d7) {
                d7 = 1.0 - d6;
                n4 = 5;
            }
            float f = this.random.nextFloat() * 0.2f + 0.1f;
            if (n4 == 0) {
                this.xd = -f;
            }
            if (n4 == 1) {
                this.xd = f;
            }
            if (n4 == 2) {
                this.yd = -f;
            }
            if (n4 == 3) {
                this.yd = f;
            }
            if (n4 == 4) {
                this.zd = -f;
            }
            if (n4 == 5) {
                this.zd = f;
            }
        }
        return false;
    }

    protected void burn(int n) {
        this.hurt(null, n);
    }

    public boolean hurt(Entity entity, int n) {
        this.markHurt();
        this.health -= n;
        if (this.health <= 0) {
            this.remove();
        }
        return false;
    }

    public void addAdditonalSaveData(CompoundTag compoundTag) {
        compoundTag.putShort("Health", (byte)this.health);
        compoundTag.putShort("Age", (short)this.age);
        compoundTag.putCompound("Item", this.item.save(new CompoundTag()));
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        this.health = compoundTag.getShort("Health") & 0xFF;
        this.age = compoundTag.getShort("Age");
        CompoundTag compoundTag2 = compoundTag.getCompound("Item");
        this.item = new ItemInstance(compoundTag2);
    }

    public void playerTouch(Player player) {
        if (this.level.isOnline) {
            return;
        }
        int n = this.item.count;
        if (this.throwTime == 0 && player.inventory.add(this.item)) {
            this.level.playSound(this, "random.pop", 0.2f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            player.take(this, n);
            this.remove();
        }
    }
}

