/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import util.Mth;

public class FallingTile
extends Entity {
    public static final long serialVersionUID = 0L;
    public int tile;
    public int time = 0;

    public FallingTile(Level level) {
        super(level);
    }

    public FallingTile(Level level, double d, double d2, double d3, int n) {
        super(level);
        this.tile = n;
        this.blocksBuilding = true;
        this.setSize(0.98f, 0.98f);
        this.heightOffset = this.bbHeight / 2.0f;
        this.setPos(d, d2, d3);
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.makeStepSound = false;
        this.xo = d;
        this.yo = d2;
        this.zo = d3;
    }

    protected void defineSynchedData() {
    }

    public boolean isPickable() {
        return !this.removed;
    }

    public void tick() {
        if (this.tile == 0) {
            this.remove();
            return;
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        ++this.time;
        this.yd -= (double)0.04f;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= (double)0.98f;
        this.yd *= (double)0.98f;
        this.zd *= (double)0.98f;
        int n = Mth.floor(this.x);
        int n2 = Mth.floor(this.y);
        int n3 = Mth.floor(this.z);
        if (this.level.getTile(n, n2, n3) == this.tile) {
            this.level.setTile(n, n2, n3, 0);
        }
        if (this.onGround) {
            this.xd *= (double)0.7f;
            this.zd *= (double)0.7f;
            this.yd *= -0.5;
            this.remove();
            if (!(this.level.mayPlace(this.tile, n, n2, n3, true) && this.level.setTile(n, n2, n3, this.tile) || this.level.isOnline)) {
                this.spawnAtLocation(this.tile, 1);
            }
        } else if (this.time > 100 && !this.level.isOnline) {
            this.spawnAtLocation(this.tile, 1);
            this.remove();
        }
    }

    protected void addAdditonalSaveData(CompoundTag compoundTag) {
        compoundTag.putByte("Tile", (byte)this.tile);
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        this.tile = compoundTag.getByte("Tile") & 0xFF;
    }

    public float getShadowHeightOffs() {
        return 0.0f;
    }

    public Level getLevel() {
        return this.level;
    }
}

