/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.nbt.CompoundTag;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.AABB;

public class Boat
extends Entity {
    public static final long serialVersionUID = 0L;
    public int damage = 0;
    public int hurtTime = 0;
    public int hurtDir = 1;
    private int lSteps;
    private double lx;
    private double ly;
    private double lz;
    private double lyr;
    private double lxr;
    private double lxd;
    private double lyd;
    private double lzd;

    public Boat(Level level) {
        super(level);
        this.blocksBuilding = true;
        this.setSize(1.5f, 0.6f);
        this.heightOffset = this.bbHeight / 2.0f;
        this.makeStepSound = false;
    }

    protected void defineSynchedData() {
    }

    public AABB getCollideAgainstBox(Entity entity) {
        return entity.bb;
    }

    public AABB getCollideBox() {
        return this.bb;
    }

    public boolean isPushable() {
        return true;
    }

    public Boat(Level level, double d, double d2, double d3) {
        this(level);
        this.setPos(d, d2 + (double)this.heightOffset, d3);
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.xo = d;
        this.yo = d2;
        this.zo = d3;
    }

    public double getRideHeight() {
        return (double)this.bbHeight * 0.0 - (double)0.3f;
    }

    public boolean hurt(Entity entity, int n) {
        if (this.level.isOnline || this.removed) {
            return true;
        }
        this.hurtDir = -this.hurtDir;
        this.hurtTime = 10;
        this.damage += n * 10;
        this.markHurt();
        if (this.damage > 40) {
            int n2;
            for (n2 = 0; n2 < 3; ++n2) {
                this.spawnAtLocation(Tile.wood.id, 1, 0.0f);
            }
            for (n2 = 0; n2 < 2; ++n2) {
                this.spawnAtLocation(Item.stick.id, 1, 0.0f);
            }
            this.remove();
        }
        return true;
    }

    public void animateHurt() {
        this.hurtDir = -this.hurtDir;
        this.hurtTime = 10;
        this.damage += this.damage * 10;
    }

    public boolean isPickable() {
        return !this.removed;
    }

    public void lerpTo(double d, double d2, double d3, float f, float f2, int n) {
        this.lx = d;
        this.ly = d2;
        this.lz = d3;
        this.lyr = f;
        this.lxr = f2;
        this.lSteps = n + 4;
        this.xd = this.lxd;
        this.yd = this.lyd;
        this.zd = this.lzd;
    }

    public void lerpMotion(double d, double d2, double d3) {
        this.lxd = this.xd = d;
        this.lyd = this.yd = d2;
        this.lzd = this.zd = d3;
    }

    public void tick() {
        double d;
        double d2;
        double d3;
        super.tick();
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        if (this.damage > 0) {
            --this.damage;
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        int n = 5;
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d5 = this.bb.y0 + (this.bb.y1 - this.bb.y0) * (double)(i + 0) / (double)n - 0.125;
            double d6 = this.bb.y0 + (this.bb.y1 - this.bb.y0) * (double)(i + 1) / (double)n - 0.125;
            AABB aABB = AABB.newTemp(this.bb.x0, d5, this.bb.z0, this.bb.x1, d6, this.bb.z1);
            if (!this.level.containsLiquid(aABB, Material.water)) continue;
            d4 += 1.0 / (double)n;
        }
        if (this.level.isOnline) {
            if (this.lSteps > 0) {
                double d7;
                double d8 = this.x + (this.lx - this.x) / (double)this.lSteps;
                double d9 = this.y + (this.ly - this.y) / (double)this.lSteps;
                double d10 = this.z + (this.lz - this.z) / (double)this.lSteps;
                for (d7 = this.lyr - (double)this.yRot; d7 < -180.0; d7 += 360.0) {
                }
                while (d7 >= 180.0) {
                    d7 -= 360.0;
                }
                this.yRot = (float)((double)this.yRot + d7 / (double)this.lSteps);
                this.xRot = (float)((double)this.xRot + (this.lxr - (double)this.xRot) / (double)this.lSteps);
                --this.lSteps;
                this.setPos(d8, d9, d10);
                this.setRot(this.yRot, this.xRot);
            } else {
                double d11 = this.x + this.xd;
                double d12 = this.y + this.yd;
                double d13 = this.z + this.zd;
                this.setPos(d11, d12, d13);
                if (this.onGround) {
                    this.xd *= 0.5;
                    this.yd *= 0.5;
                    this.zd *= 0.5;
                }
                this.xd *= (double)0.99f;
                this.yd *= (double)0.95f;
                this.zd *= (double)0.99f;
            }
            return;
        }
        double d14 = d4 * 2.0 - 1.0;
        this.yd += (double)0.04f * d14;
        if (this.rider != null) {
            this.xd += this.rider.xd * 0.2;
            this.zd += this.rider.zd * 0.2;
        }
        if (this.xd < -(d3 = 0.4)) {
            this.xd = -d3;
        }
        if (this.xd > d3) {
            this.xd = d3;
        }
        if (this.zd < -d3) {
            this.zd = -d3;
        }
        if (this.zd > d3) {
            this.zd = d3;
        }
        if (this.onGround) {
            this.xd *= 0.5;
            this.yd *= 0.5;
            this.zd *= 0.5;
        }
        this.move(this.xd, this.yd, this.zd);
        double d15 = Math.sqrt(this.xd * this.xd + this.zd * this.zd);
        if (d15 > 0.15) {
            double d16 = Math.cos((double)this.yRot * Math.PI / 180.0);
            d2 = Math.sin((double)this.yRot * Math.PI / 180.0);
            int n2 = 0;
            while ((double)n2 < 1.0 + d15 * 60.0) {
                double d17;
                double d18;
                double d19 = this.random.nextFloat() * 2.0f - 1.0f;
                double d20 = (double)(this.random.nextInt(2) * 2 - 1) * 0.7;
                if (this.random.nextBoolean()) {
                    d18 = this.x - d16 * d19 * 0.8 + d2 * d20;
                    d17 = this.z - d2 * d19 * 0.8 - d16 * d20;
                    this.level.addParticle("splash", d18, this.y - 0.125, d17, this.xd, this.yd, this.zd);
                } else {
                    d18 = this.x + d16 + d2 * d19 * 0.7;
                    d17 = this.z + d2 - d16 * d19 * 0.7;
                    this.level.addParticle("splash", d18, this.y - 0.125, d17, this.xd, this.yd, this.zd);
                }
                ++n2;
            }
        }
        if (this.horizontalCollision && d15 > 0.15) {
            if (!this.level.isOnline) {
                int n3;
                this.remove();
                for (n3 = 0; n3 < 3; ++n3) {
                    this.spawnAtLocation(Tile.wood.id, 1, 0.0f);
                }
                for (n3 = 0; n3 < 2; ++n3) {
                    this.spawnAtLocation(Item.stick.id, 1, 0.0f);
                }
            }
        } else {
            this.xd *= (double)0.99f;
            this.yd *= (double)0.95f;
            this.zd *= (double)0.99f;
        }
        this.xRot = 0.0f;
        double d21 = this.yRot;
        d2 = this.xo - this.x;
        double d22 = this.zo - this.z;
        if (d2 * d2 + d22 * d22 > 0.001) {
            d21 = (float)(Math.atan2(d22, d2) * 180.0 / Math.PI);
        }
        for (d = d21 - (double)this.yRot; d >= 180.0; d -= 360.0) {
        }
        while (d < -180.0) {
            d += 360.0;
        }
        if (d > 20.0) {
            d = 20.0;
        }
        if (d < -20.0) {
            d = -20.0;
        }
        this.yRot = (float)((double)this.yRot + d);
        this.setRot(this.yRot, this.xRot);
        List<Entity> list = this.level.getEntities(this, this.bb.grow(0.2f, 0.0, 0.2f));
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = list.get(i);
                if (entity == this.rider || !entity.isPushable() || !(entity instanceof Boat)) continue;
                entity.push(this);
            }
        }
        if (this.rider != null && this.rider.removed) {
            this.rider = null;
        }
    }

    public void positionRider() {
        if (this.rider == null) {
            return;
        }
        double d = Math.cos((double)this.yRot * Math.PI / 180.0) * 0.4;
        double d2 = Math.sin((double)this.yRot * Math.PI / 180.0) * 0.4;
        this.rider.setPos(this.x + d, this.y + this.getRideHeight() + this.rider.getRidingHeight(), this.z + d2);
    }

    protected void addAdditonalSaveData(CompoundTag compoundTag) {
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
    }

    public float getShadowHeightOffs() {
        return 0.0f;
    }

    public String getName() {
        return "Boat";
    }

    public void setChanged() {
    }

    public boolean interact(Player player) {
        if (this.rider != null && this.rider instanceof Player && this.rider != player) {
            return true;
        }
        if (!this.level.isOnline) {
            player.ride(this);
        }
        return true;
    }
}

