/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.nbt.CompoundTag;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import util.Mth;

public class Squid
extends WaterAnimal {
    public float xBodyRot = 0.0f;
    public float xBodyRotO = 0.0f;
    public float zBodyRot = 0.0f;
    public float zBodyRotO = 0.0f;
    public float tentacleMovement = 0.0f;
    public float oldTentacleMovement = 0.0f;
    public float tentacleAngle = 0.0f;
    public float oldTentacleAngle = 0.0f;
    private float speed = 0.0f;
    private float tentacleSpeed = 0.0f;
    private float rotateSpeed = 0.0f;
    private float tx = 0.0f;
    private float ty = 0.0f;
    private float tz = 0.0f;

    public Squid(Level level) {
        super(level);
        this.textureName = "/mob/squid.png";
        this.setSize(0.95f, 0.95f);
        this.tentacleSpeed = 1.0f / (this.random.nextFloat() + 1.0f) * 0.2f;
    }

    public void addAdditonalSaveData(CompoundTag compoundTag) {
        super.addAdditonalSaveData(compoundTag);
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
    }

    protected String getAmbientSound() {
        return null;
    }

    protected String getHurtSound() {
        return null;
    }

    protected String getDeathSound() {
        return null;
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    protected int getDeathLoot() {
        return 0;
    }

    protected void dropDeathLoot() {
        int n = this.random.nextInt(3) + 1;
        for (int i = 0; i < n; ++i) {
            this.spawnAtLocation(new ItemInstance(Item.dye_powder, 1, 0), 0.0f);
        }
    }

    public boolean interact(Player player) {
        ItemInstance itemInstance = player.inventory.getSelected();
        if (itemInstance != null && itemInstance.id == Item.bucket_empty.id) {
            player.inventory.setItem(player.inventory.selected, new ItemInstance(Item.milk));
            return true;
        }
        return false;
    }

    public boolean isInWater() {
        return this.level.checkAndHandleWater(this.bb.grow(0.0, -0.6f, 0.0), Material.water, this);
    }

    public void aiStep() {
        super.aiStep();
        this.xBodyRotO = this.xBodyRot;
        this.zBodyRotO = this.zBodyRot;
        this.oldTentacleMovement = this.tentacleMovement;
        this.oldTentacleAngle = this.tentacleAngle;
        this.tentacleMovement += this.tentacleSpeed;
        if (this.tentacleMovement > (float)Math.PI * 2) {
            this.tentacleMovement -= (float)Math.PI * 2;
            if (this.random.nextInt(10) == 0) {
                this.tentacleSpeed = 1.0f / (this.random.nextFloat() + 1.0f) * 0.2f;
            }
        }
        if (this.isInWater()) {
            float f;
            if (this.tentacleMovement < (float)Math.PI) {
                f = this.tentacleMovement / (float)Math.PI;
                this.tentacleAngle = Mth.sin(f * f * (float)Math.PI) * (float)Math.PI * 0.25f;
                if ((double)f > 0.75) {
                    this.speed = 1.0f;
                    this.rotateSpeed = 1.0f;
                } else {
                    this.rotateSpeed *= 0.8f;
                }
            } else {
                this.tentacleAngle = 0.0f;
                this.speed *= 0.9f;
                this.rotateSpeed *= 0.99f;
            }
            if (!this.interpolateOnly) {
                this.xd = this.tx * this.speed;
                this.yd = this.ty * this.speed;
                this.zd = this.tz * this.speed;
            }
            f = Mth.sqrt(this.xd * this.xd + this.zd * this.zd);
            this.yBodyRot += (-((float)Math.atan2(this.xd, this.zd)) * 180.0f / (float)Math.PI - this.yBodyRot) * 0.1f;
            this.yRot = this.yBodyRot;
            this.zBodyRot += (float)Math.PI * this.rotateSpeed * 1.5f;
            this.xBodyRot += (-((float)Math.atan2(f, this.yd)) * 180.0f / (float)Math.PI - this.xBodyRot) * 0.1f;
        } else {
            this.tentacleAngle = Mth.abs(Mth.sin(this.tentacleMovement)) * (float)Math.PI * 0.25f;
            if (!this.interpolateOnly) {
                this.xd = 0.0;
                this.yd -= 0.08;
                this.yd *= (double)0.98f;
                this.zd = 0.0;
            }
            this.xBodyRot = (float)((double)this.xBodyRot + (double)(-90.0f - this.xBodyRot) * 0.02);
        }
    }

    public void travel(float f, float f2) {
        this.move(this.xd, this.yd, this.zd);
    }

    protected void updateAi() {
        if (this.random.nextInt(50) == 0 || !this.wasInWater || this.tx == 0.0f && this.ty == 0.0f && this.tz == 0.0f) {
            float f = this.random.nextFloat() * (float)Math.PI * 2.0f;
            this.tx = Mth.cos(f) * 0.2f;
            this.ty = -0.1f + this.random.nextFloat() * 0.2f;
            this.tz = Mth.sin(f) * 0.2f;
        }
    }
}

