/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.nbt.CompoundTag;
import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.tile.Tile;

public class Sheep
extends Animal {
    private static final int DATA_WOOL_ID = 16;
    public static final float[][] COLOR = new float[][]{{1.0f, 1.0f, 1.0f}, {0.95f, 0.7f, 0.2f}, {0.9f, 0.5f, 0.85f}, {0.6f, 0.7f, 0.95f}, {0.9f, 0.9f, 0.2f}, {0.5f, 0.8f, 0.1f}, {0.95f, 0.7f, 0.8f}, {0.3f, 0.3f, 0.3f}, {0.6f, 0.6f, 0.6f}, {0.3f, 0.6f, 0.7f}, {0.7f, 0.4f, 0.9f}, {0.2f, 0.4f, 0.8f}, {0.5f, 0.4f, 0.3f}, {0.4f, 0.5f, 0.2f}, {0.8f, 0.3f, 0.3f}, {0.1f, 0.1f, 0.1f}};

    public Sheep(Level level) {
        super(level);
        this.textureName = "/mob/sheep.png";
        this.setSize(0.9f, 1.3f);
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(16, new Byte(0));
    }

    public boolean hurt(Entity entity, int n) {
        if (!this.level.isOnline && !this.isSheared() && entity instanceof Mob) {
            this.setSheared(true);
            int n2 = 1 + this.random.nextInt(3);
            for (int i = 0; i < n2; ++i) {
                ItemEntity itemEntity = this.spawnAtLocation(new ItemInstance(Tile.cloth.id, 1, this.getColor()), 1.0f);
                itemEntity.yd += (double)(this.random.nextFloat() * 0.05f);
                itemEntity.xd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
                itemEntity.zd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
            }
        }
        return super.hurt(entity, n);
    }

    public void addAdditonalSaveData(CompoundTag compoundTag) {
        super.addAdditonalSaveData(compoundTag);
        compoundTag.putBoolean("Sheared", this.isSheared());
        compoundTag.putByte("Color", (byte)this.getColor());
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.setSheared(compoundTag.getBoolean("Sheared"));
        this.setColor(compoundTag.getByte("Color"));
    }

    protected String getAmbientSound() {
        return "mob.sheep";
    }

    protected String getHurtSound() {
        return "mob.sheep";
    }

    protected String getDeathSound() {
        return "mob.sheep";
    }

    public int getColor() {
        return this.entityData.getByte(16) & 0xF;
    }

    public void setColor(int n) {
        byte by = this.entityData.getByte(16);
        this.entityData.set(16, (byte)(by & 0xF0 | n & 0xF));
    }

    public boolean isSheared() {
        return (this.entityData.getByte(16) & 0x10) != 0;
    }

    public void setSheared(boolean bl) {
        byte by = this.entityData.getByte(16);
        if (bl) {
            this.entityData.set(16, (byte)(by | 0x10));
        } else {
            this.entityData.set(16, (byte)(by & 0xFFFFFFEF));
        }
    }

    public static int getSheepColor(Random random) {
        int n = random.nextInt(100);
        if (n < 5) {
            return 15;
        }
        if (n < 10) {
            return 7;
        }
        if (n < 15) {
            return 8;
        }
        return 0;
    }
}

