/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.nbt.CompoundTag;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class Pig
extends Animal {
    private static final int DATA_SADDLE_ID = 16;

    public Pig(Level level) {
        super(level);
        this.textureName = "/mob/pig.png";
        this.setSize(0.9f, 0.9f);
    }

    protected void defineSynchedData() {
        this.entityData.define(16, (byte)0);
    }

    public void addAdditonalSaveData(CompoundTag compoundTag) {
        super.addAdditonalSaveData(compoundTag);
        compoundTag.putBoolean("Saddle", this.hasSaddle());
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.setSaddle(compoundTag.getBoolean("Saddle"));
    }

    protected String getAmbientSound() {
        return "mob.pig";
    }

    protected String getHurtSound() {
        return "mob.pig";
    }

    protected String getDeathSound() {
        return "mob.pigdeath";
    }

    public boolean interact(Player player) {
        if (this.hasSaddle() && !this.level.isOnline && (this.rider == null || this.rider == player)) {
            player.ride(this);
            return true;
        }
        return false;
    }

    protected int getDeathLoot() {
        return Item.porkChop_raw.id;
    }

    public boolean hasSaddle() {
        return (this.entityData.getByte(16) & 1) != 0;
    }

    public void setSaddle(boolean bl) {
        if (bl) {
            this.entityData.set(16, (byte)1);
        } else {
            this.entityData.set(16, (byte)0);
        }
    }
}

