/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.ItemInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchedEntityData {
    public static final int EOF_MARKER = 127;
    private static final int TYPE_BYTE = 0;
    private static final int TYPE_SHORT = 1;
    private static final int TYPE_INT = 2;
    private static final int TYPE_FLOAT = 3;
    private static final int TYPE_STRING = 4;
    private static final int TYPE_ITEMINSTANCE = 5;
    private static final HashMap<Class<?>, Integer> typeToConstant = new HashMap();
    private static final int TYPE_MASK = 224;
    private static final int TYPE_SHIFT = 5;
    private static final int MAX_ID_VALUE = 31;
    private final Map<Integer, DataItem> itemsById = new HashMap<Integer, DataItem>();
    private boolean isDirty;

    public <T> void define(int n, T t) {
        Integer n2 = typeToConstant.get(t.getClass());
        if (n2 == null) {
            throw new IllegalArgumentException("Unknown data type: " + t.getClass());
        }
        if (n > 31) {
            throw new IllegalArgumentException("Data value id is too big with " + n + "! (Max is " + 31 + ")");
        }
        if (this.itemsById.containsKey(n)) {
            throw new IllegalArgumentException("Duplicate id value for " + n + "!");
        }
        DataItem dataItem = new DataItem(n2, n, t);
        this.itemsById.put(n, dataItem);
    }

    public byte getByte(int n) {
        return (Byte)this.itemsById.get(n).getValue();
    }

    public short getShort(int n) {
        return (Short)this.itemsById.get(n).getValue();
    }

    public int getInteger(int n) {
        return (Integer)this.itemsById.get(n).getValue();
    }

    public float getFloat(int n) {
        return ((Float)this.itemsById.get(n).getValue()).floatValue();
    }

    public String getString(int n) {
        return (String)this.itemsById.get(n).getValue();
    }

    public ItemInstance getItemInstance(int n) {
        return (ItemInstance)this.itemsById.get(n).getValue();
    }

    public <T> void set(int n, T t) {
        DataItem dataItem = this.itemsById.get(n);
        if (!t.equals(dataItem.getValue())) {
            dataItem.setValue(t);
            dataItem.setDirty(true);
            this.isDirty = true;
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public static void pack(List<DataItem> list, DataOutputStream dataOutputStream) throws IOException {
        if (list != null) {
            for (DataItem dataItem : list) {
                SynchedEntityData.writeDataItem(dataOutputStream, dataItem);
            }
        }
        dataOutputStream.writeByte(127);
    }

    public ArrayList<DataItem> packDirty() {
        ArrayList<DataItem> arrayList = null;
        if (this.isDirty) {
            for (DataItem dataItem : this.itemsById.values()) {
                if (!dataItem.isDirty()) continue;
                dataItem.setDirty(false);
                if (arrayList == null) {
                    arrayList = new ArrayList<DataItem>();
                }
                arrayList.add(dataItem);
            }
        }
        this.isDirty = false;
        return arrayList;
    }

    public void packAll(DataOutputStream dataOutputStream) throws IOException {
        for (DataItem dataItem : this.itemsById.values()) {
            SynchedEntityData.writeDataItem(dataOutputStream, dataItem);
        }
        dataOutputStream.writeByte(127);
    }

    private static void writeDataItem(DataOutputStream dataOutputStream, DataItem dataItem) throws IOException {
        int n = (dataItem.getType() << 5 | dataItem.getId() & 0x1F) & 0xFF;
        dataOutputStream.writeByte(n);
        switch (dataItem.getType()) {
            case 0: {
                dataOutputStream.writeByte(((Byte)dataItem.getValue()).byteValue());
                break;
            }
            case 1: {
                dataOutputStream.writeShort(((Short)dataItem.getValue()).shortValue());
                break;
            }
            case 2: {
                dataOutputStream.writeInt((Integer)dataItem.getValue());
                break;
            }
            case 3: {
                dataOutputStream.writeFloat(((Float)dataItem.getValue()).floatValue());
                break;
            }
            case 4: {
                dataOutputStream.writeUTF((String)dataItem.getValue());
                break;
            }
            case 5: {
                ItemInstance itemInstance = (ItemInstance)dataItem.getValue();
                dataOutputStream.writeShort(itemInstance.getItem().id);
                dataOutputStream.writeByte(itemInstance.count);
                dataOutputStream.writeShort(itemInstance.getAuxValue());
            }
        }
    }

    public static List<DataItem> unpack(DataInputStream dataInputStream) throws IOException {
        ArrayList<DataItem> arrayList = null;
        byte by = dataInputStream.readByte();
        while (by != 127) {
            if (arrayList == null) {
                arrayList = new ArrayList<DataItem>();
            }
            int n = (by & 0xE0) >> 5;
            int n2 = by & 0x1F;
            DataItem dataItem = null;
            switch (n) {
                case 0: {
                    dataItem = new DataItem(n, n2, dataInputStream.readByte());
                    break;
                }
                case 1: {
                    dataItem = new DataItem(n, n2, dataInputStream.readShort());
                    break;
                }
                case 2: {
                    dataItem = new DataItem(n, n2, dataInputStream.readInt());
                    break;
                }
                case 3: {
                    dataItem = new DataItem(n, n2, Float.valueOf(dataInputStream.readFloat()));
                    break;
                }
                case 4: {
                    dataItem = new DataItem(n, n2, dataInputStream.readUTF());
                    break;
                }
                case 5: {
                    short s = dataInputStream.readShort();
                    byte by2 = dataInputStream.readByte();
                    short s2 = dataInputStream.readShort();
                    dataItem = new DataItem(n, n2, new ItemInstance(s, (int)by2, (int)s2));
                }
            }
            arrayList.add(dataItem);
            by = dataInputStream.readByte();
        }
        return arrayList;
    }

    public void assignValues(List<DataItem> list) {
        for (DataItem dataItem : list) {
            DataItem dataItem2 = this.itemsById.get(dataItem.getId());
            if (dataItem2 == null) continue;
            dataItem2.setValue(dataItem.getValue());
        }
    }

    static {
        typeToConstant.put(Byte.class, 0);
        typeToConstant.put(Short.class, 1);
        typeToConstant.put(Integer.class, 2);
        typeToConstant.put(Float.class, 3);
        typeToConstant.put(String.class, 4);
        typeToConstant.put(ItemInstance.class, 5);
    }

    public static class DataItem {
        private final int type;
        private final int id;
        private Object value;
        private boolean dirty;

        public DataItem(int n, int n2, Object object) {
            this.id = n2;
            this.value = object;
            this.type = n;
            this.dirty = true;
        }

        public int getId() {
            return this.id;
        }

        public void setValue(Object object) {
            this.value = object;
        }

        public Object getValue() {
            return this.value;
        }

        public int getType() {
            return this.type;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void setDirty(boolean bl) {
            this.dirty = bl;
        }
    }
}

