/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import util.Mth;

public class PathfinderMob
extends Mob {
    private static final int MAX_TURN = 30;
    private Path path;
    protected Entity attackTarget;
    protected boolean holdGround = false;

    public PathfinderMob(Level level) {
        super(level);
    }

    protected void updateAi() {
        int n;
        int n2;
        this.holdGround = false;
        float f = 16.0f;
        if (this.attackTarget == null) {
            this.attackTarget = this.findAttackTarget();
            if (this.attackTarget != null) {
                this.path = this.level.findPath(this, this.attackTarget, f);
            }
        } else if (!this.attackTarget.isAlive()) {
            this.attackTarget = null;
        } else {
            float f2 = this.attackTarget.distanceTo(this);
            if (this.canSee(this.attackTarget)) {
                this.checkHurtTarget(this.attackTarget, f2);
            }
        }
        if (!(this.holdGround || this.attackTarget == null || this.path != null && this.random.nextInt(20) != 0)) {
            this.path = this.level.findPath(this, this.attackTarget, f);
        } else if (this.path == null && this.random.nextInt(80) == 0 || this.random.nextInt(80) == 0) {
            boolean bl = false;
            n2 = -1;
            n = -1;
            int n3 = -1;
            float f3 = -99999.0f;
            for (int i = 0; i < 10; ++i) {
                int n4;
                int n5;
                int n6 = Mth.floor(this.x + (double)this.random.nextInt(13) - 6.0);
                float f4 = this.getWalkTargetValue(n6, n5 = Mth.floor(this.y + (double)this.random.nextInt(7) - 3.0), n4 = Mth.floor(this.z + (double)this.random.nextInt(13) - 6.0));
                if (!(f4 > f3)) continue;
                f3 = f4;
                n2 = n6;
                n = n5;
                n3 = n4;
                bl = true;
            }
            if (bl) {
                this.path = this.level.findPath(this, n2, n, n3, 10.0f);
            }
        }
        int n7 = Mth.floor(this.bb.y0);
        n2 = this.isInWater() ? 1 : 0;
        n = this.isInLava() ? 1 : 0;
        this.xRot = 0.0f;
        if (this.path == null || this.random.nextInt(100) == 0) {
            super.updateAi();
            this.path = null;
            return;
        }
        Vec3 vec3 = this.path.current(this);
        double d = this.bbWidth * 2.0f;
        while (vec3 != null && vec3.distanceToSqr(this.x, vec3.y, this.z) < d * d) {
            this.path.next();
            if (this.path.isDone()) {
                vec3 = null;
                this.path = null;
                continue;
            }
            vec3 = this.path.current(this);
        }
        this.jumping = false;
        if (vec3 != null) {
            float f5;
            double d2 = vec3.x - this.x;
            double d3 = vec3.z - this.z;
            double d4 = vec3.y - (double)n7;
            float f6 = (float)(Math.atan2(d3, d2) * 180.0 / 3.1415927410125732) - 90.0f;
            this.yya = this.runSpeed;
            for (f5 = f6 - this.yRot; f5 < -180.0f; f5 += 360.0f) {
            }
            while (f5 >= 180.0f) {
                f5 -= 360.0f;
            }
            if (f5 > 30.0f) {
                f5 = 30.0f;
            }
            if (f5 < -30.0f) {
                f5 = -30.0f;
            }
            this.yRot += f5;
            if (this.holdGround && this.attackTarget != null) {
                double d5 = this.attackTarget.x - this.x;
                double d6 = this.attackTarget.z - this.z;
                float f7 = this.yRot;
                this.yRot = (float)(Math.atan2(d6, d5) * 180.0 / 3.1415927410125732) - 90.0f;
                f5 = (f7 - this.yRot + 90.0f) * (float)Math.PI / 180.0f;
                this.xxa = -Mth.sin(f5) * this.yya * 1.0f;
                this.yya = Mth.cos(f5) * this.yya * 1.0f;
            }
            if (d4 > 0.0) {
                this.jumping = true;
            }
        }
        if (this.attackTarget != null) {
            this.lookAt(this.attackTarget, 30.0f);
        }
        if (this.horizontalCollision) {
            this.jumping = true;
        }
        if (this.random.nextFloat() < 0.8f && (n2 != 0 || n != 0)) {
            this.jumping = true;
        }
    }

    protected void checkHurtTarget(Entity entity, float f) {
    }

    protected float getWalkTargetValue(int n, int n2, int n3) {
        return 0.0f;
    }

    protected Entity findAttackTarget() {
        return null;
    }

    public boolean canSpawn() {
        int n = Mth.floor(this.x);
        int n2 = Mth.floor(this.bb.y0);
        int n3 = Mth.floor(this.z);
        return super.canSpawn() && this.getWalkTargetValue(n, n2, n3) >= 0.0f;
    }
}

