/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.nbt.CompoundTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import util.Mth;

public class Painting
extends Entity {
    private int checkInterval = 0;
    public int dir = 0;
    public int xTile;
    public int yTile;
    public int zTile;
    public Motive motive;

    public Painting(Level level) {
        super(level);
        this.heightOffset = 0.0f;
        this.setSize(0.5f, 0.5f);
    }

    public Painting(Level level, int n, int n2, int n3, int n4) {
        this(level);
        this.xTile = n;
        this.yTile = n2;
        this.zTile = n3;
        ArrayList<Motive> arrayList = new ArrayList<Motive>();
        Motive[] motiveArray = Motive.values();
        int n5 = motiveArray.length;
        for (int i = 0; i < n5; ++i) {
            Motive motive;
            this.motive = motive = motiveArray[i];
            this.setDir(n4);
            if (!this.survives()) continue;
            arrayList.add(motive);
        }
        if (arrayList.size() > 0) {
            this.motive = (Motive)((Object)arrayList.get(this.random.nextInt(arrayList.size())));
        }
        this.setDir(n4);
    }

    public Painting(Level level, int n, int n2, int n3, int n4, String string) {
        this(level);
        this.xTile = n;
        this.yTile = n2;
        this.zTile = n3;
        for (Motive motive : Motive.values()) {
            if (!motive.name.equals(string)) continue;
            this.motive = motive;
            break;
        }
        this.setDir(n4);
    }

    protected void defineSynchedData() {
    }

    public void setDir(int n) {
        this.dir = n;
        this.yRotO = this.yRot = (float)(n * 90);
        float f = this.motive.w;
        float f2 = this.motive.h;
        float f3 = this.motive.w;
        if (n == 0 || n == 2) {
            f3 = 0.5f;
        } else {
            f = 0.5f;
        }
        f /= 32.0f;
        f2 /= 32.0f;
        f3 /= 32.0f;
        float f4 = (float)this.xTile + 0.5f;
        float f5 = (float)this.yTile + 0.5f;
        float f6 = (float)this.zTile + 0.5f;
        float f7 = 0.5625f;
        if (n == 0) {
            f6 -= f7;
        }
        if (n == 1) {
            f4 -= f7;
        }
        if (n == 2) {
            f6 += f7;
        }
        if (n == 3) {
            f4 += f7;
        }
        if (n == 0) {
            f4 -= this.offs(this.motive.w);
        }
        if (n == 1) {
            f6 += this.offs(this.motive.w);
        }
        if (n == 2) {
            f4 += this.offs(this.motive.w);
        }
        if (n == 3) {
            f6 -= this.offs(this.motive.w);
        }
        this.setPos(f4, f5 += this.offs(this.motive.h), f6);
        float f8 = -0.00625f;
        this.bb.set(f4 - f - f8, f5 - f2 - f8, f6 - f3 - f8, f4 + f + f8, f5 + f2 + f8, f6 + f3 + f8);
    }

    private float offs(int n) {
        if (n == 32) {
            return 0.5f;
        }
        if (n == 64) {
            return 0.5f;
        }
        return 0.0f;
    }

    public void tick() {
        if (this.checkInterval++ == 100 && !this.level.isOnline) {
            this.checkInterval = 0;
            if (!this.survives()) {
                this.remove();
                this.level.addEntity(new ItemEntity(this.level, this.x, this.y, this.z, new ItemInstance(Item.painting)));
            }
        }
    }

    public boolean survives() {
        int n;
        if (this.level.getCubes(this, this.bb).size() > 0) {
            return false;
        }
        int n2 = this.motive.w / 16;
        int n3 = this.motive.h / 16;
        int n4 = this.xTile;
        int n5 = this.yTile;
        int n6 = this.zTile;
        if (this.dir == 0) {
            n4 = Mth.floor(this.x - (double)((float)this.motive.w / 32.0f));
        }
        if (this.dir == 1) {
            n6 = Mth.floor(this.z - (double)((float)this.motive.w / 32.0f));
        }
        if (this.dir == 2) {
            n4 = Mth.floor(this.x - (double)((float)this.motive.w / 32.0f));
        }
        if (this.dir == 3) {
            n6 = Mth.floor(this.z - (double)((float)this.motive.w / 32.0f));
        }
        n5 = Mth.floor(this.y - (double)((float)this.motive.h / 32.0f));
        for (int i = 0; i < n2; ++i) {
            for (n = 0; n < n3; ++n) {
                Material material = this.dir == 0 || this.dir == 2 ? this.level.getMaterial(n4 + i, n5 + n, this.zTile) : this.level.getMaterial(this.xTile, n5 + n, n6 + i);
                if (material.isSolid()) continue;
                return false;
            }
        }
        List<Entity> list = this.level.getEntities(this, this.bb);
        for (n = 0; n < list.size(); ++n) {
            if (!(list.get(n) instanceof Painting)) continue;
            return false;
        }
        return true;
    }

    public boolean isPickable() {
        return true;
    }

    public boolean hurt(Entity entity, int n) {
        if (!this.removed && !this.level.isOnline) {
            this.remove();
            this.markHurt();
            this.level.addEntity(new ItemEntity(this.level, this.x, this.y, this.z, new ItemInstance(Item.painting)));
        }
        return true;
    }

    public void addAdditonalSaveData(CompoundTag compoundTag) {
        compoundTag.putByte("Dir", (byte)this.dir);
        compoundTag.putString("Motive", this.motive.name);
        compoundTag.putInt("TileX", this.xTile);
        compoundTag.putInt("TileY", this.yTile);
        compoundTag.putInt("TileZ", this.zTile);
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        this.dir = compoundTag.getByte("Dir");
        this.xTile = compoundTag.getInt("TileX");
        this.yTile = compoundTag.getInt("TileY");
        this.zTile = compoundTag.getInt("TileZ");
        String string = compoundTag.getString("Motive");
        for (Motive motive : Motive.values()) {
            if (!motive.name.equals(string)) continue;
            this.motive = motive;
        }
        if (this.motive == null) {
            this.motive = Motive.Kebab;
        }
        this.setDir(this.dir);
    }

    public static Motive randomMotive() {
        return Motive.values()[new Random().nextInt(Motive.values().length)];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Motive {
        Kebab("Kebab", 16, 16, 0, 0),
        Aztec("Aztec", 16, 16, 16, 0),
        Alban("Alban", 16, 16, 32, 0),
        Aztec2("Aztec2", 16, 16, 48, 0),
        Bomb("Bomb", 16, 16, 64, 0),
        Plant("Plant", 16, 16, 80, 0),
        Wasteland("Wasteland", 16, 16, 96, 0),
        Pool("Pool", 32, 16, 0, 32),
        Courbet("Courbet", 32, 16, 32, 32),
        Sea("Sea", 32, 16, 64, 32),
        Sunset("Sunset", 32, 16, 96, 32),
        Creebet("Creebet", 32, 16, 128, 32),
        Wanderer("Wanderer", 16, 32, 0, 64),
        Graham("Graham", 16, 32, 16, 64),
        Match("Match", 32, 32, 0, 128),
        Bust("Bust", 32, 32, 32, 128),
        Stage("Stage", 32, 32, 64, 128),
        Void("Void", 32, 32, 96, 128),
        SkullAndRoses("SkullAndRoses", 32, 32, 128, 128),
        Fighters("Fighters", 64, 32, 0, 96),
        Pointer("Pointer", 64, 64, 0, 192),
        Pigscene("Pigscene", 64, 64, 64, 192),
        BurningSkull("BurningSkull", 64, 64, 128, 192),
        Skeleton("Skeleton", 64, 48, 192, 64),
        DonkeyKong("DonkeyKong", 64, 48, 192, 112);

        public final String name;
        public final int w;
        public final int h;
        public final int uo;
        public final int vo;

        private Motive(String string2, int n2, int n3, int n4, int n5) {
            this.name = string2;
            this.w = n2;
            this.h = n3;
            this.uo = n4;
            this.vo = n5;
        }
    }
}

