/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.nbt.CompoundTag;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import util.Mth;

public abstract class Mob
extends Entity {
    public static final int ATTACK_DURATION = 5;
    public int invulnerableDuration = 20;
    public float timeOffs;
    public float rotA;
    public float yBodyRot = 0.0f;
    public float yBodyRotO = 0.0f;
    protected float oRun;
    protected float run;
    protected float animStep;
    protected float animStepO;
    protected boolean hasHair = true;
    protected String textureName = "/mob/char.png";
    protected boolean allowAlpha = true;
    protected float rotOffs = 0.0f;
    protected String modelName = null;
    protected float bobStrength = 1.0f;
    protected int deathScore = 0;
    protected float renderOffset = 0.0f;
    public boolean interpolateOnly = false;
    public float oAttackAnim;
    public float attackAnim;
    public int health = 10;
    public int lastHealth;
    private int ambientSoundTime;
    public int hurtTime;
    public int hurtDuration;
    public float hurtDir = 0.0f;
    public int deathTime = 0;
    public int attackTime = 0;
    public float oTilt;
    public float tilt;
    protected boolean dead = false;
    public int modelNum = -1;
    public float animSpeed = (float)(Math.random() * (double)0.9f + (double)0.1f);
    public float walkAnimSpeedO;
    public float walkAnimSpeed;
    public float walkAnimPos;
    protected int lSteps;
    protected double lx;
    protected double ly;
    protected double lz;
    protected double lyr;
    protected double lxr;
    float fallTime = 0.0f;
    protected int lastHurt = 0;
    protected int noActionTime = 0;
    protected float xxa;
    protected float yya;
    protected float yRotA;
    protected boolean jumping = false;
    protected float defaultLookAngle = 0.0f;
    protected float runSpeed = 0.7f;
    private Entity lookingAt;
    private int lookTime = 0;

    public Mob(Level level) {
        super(level);
        this.blocksBuilding = true;
        this.rotA = (float)(Math.random() + 1.0) * 0.01f;
        this.setPos(this.x, this.y, this.z);
        this.timeOffs = (float)Math.random() * 12398.0f;
        this.yRot = (float)(Math.random() * 3.1415927410125732 * 2.0);
        this.footSize = 0.5f;
    }

    protected void defineSynchedData() {
    }

    public boolean canSee(Entity entity) {
        return this.level.clip(Vec3.newTemp(this.x, this.y + (double)this.getHeadHeight(), this.z), Vec3.newTemp(entity.x, entity.y + (double)entity.getHeadHeight(), entity.z)) == null;
    }

    public String getTexture() {
        return this.textureName;
    }

    public boolean isPickable() {
        return !this.removed;
    }

    public boolean isPushable() {
        return !this.removed;
    }

    public float getHeadHeight() {
        return this.bbHeight * 0.85f;
    }

    public int getAmbientSoundInterval() {
        return 80;
    }

    public void baseTick() {
        this.oAttackAnim = this.attackAnim;
        super.baseTick();
        if (this.random.nextInt(1000) < this.ambientSoundTime++) {
            this.ambientSoundTime = -this.getAmbientSoundInterval();
            String string = this.getAmbientSound();
            if (string != null) {
                this.level.playSound(this, string, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            }
        }
        if (this.isAlive() && this.isInWall()) {
            this.hurt(null, 1);
        }
        if (this.fireImmune || this.level.isOnline) {
            this.onFire = 0;
        }
        if (this.isAlive() && this.isUnderLiquid(Material.water) && !this.isWaterMob()) {
            --this.airSupply;
            if (this.airSupply == -20) {
                this.airSupply = 0;
                for (int i = 0; i < 8; ++i) {
                    float f = this.random.nextFloat() - this.random.nextFloat();
                    float f2 = this.random.nextFloat() - this.random.nextFloat();
                    float f3 = this.random.nextFloat() - this.random.nextFloat();
                    this.level.addParticle("bubble", this.x + (double)f, this.y + (double)f2, this.z + (double)f3, this.xd, this.yd, this.zd);
                }
                this.hurt(null, 2);
            }
            this.onFire = 0;
        } else {
            this.airSupply = this.airCapacity;
        }
        this.oTilt = this.tilt;
        if (this.attackTime > 0) {
            --this.attackTime;
        }
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        if (this.invulnerableTime > 0) {
            --this.invulnerableTime;
        }
        if (this.health <= 0) {
            ++this.deathTime;
            if (this.deathTime > 20) {
                this.beforeRemove();
                this.remove();
                for (int i = 0; i < 20; ++i) {
                    double d = this.random.nextGaussian() * 0.02;
                    double d2 = this.random.nextGaussian() * 0.02;
                    double d3 = this.random.nextGaussian() * 0.02;
                    this.level.addParticle("explode", this.x + (double)(this.random.nextFloat() * this.bbWidth * 2.0f) - (double)this.bbWidth, this.y + (double)(this.random.nextFloat() * this.bbHeight), this.z + (double)(this.random.nextFloat() * this.bbWidth * 2.0f) - (double)this.bbWidth, d, d2, d3);
                }
            }
        }
        this.animStepO = this.animStep;
        this.yBodyRotO = this.yBodyRot;
        this.yRotO = this.yRot;
        this.xRotO = this.xRot;
    }

    public void spawnAnim() {
        for (int i = 0; i < 20; ++i) {
            double d = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            double d3 = this.random.nextGaussian() * 0.02;
            double d4 = 10.0;
            this.level.addParticle("explode", this.x + (double)(this.random.nextFloat() * this.bbWidth * 2.0f) - (double)this.bbWidth - d * d4, this.y + (double)(this.random.nextFloat() * this.bbHeight) - d2 * d4, this.z + (double)(this.random.nextFloat() * this.bbWidth * 2.0f) - (double)this.bbWidth - d3 * d4, d, d2, d3);
        }
    }

    public void rideTick() {
        super.rideTick();
        this.oRun = this.run;
        this.run = 0.0f;
    }

    public void lerpTo(double d, double d2, double d3, float f, float f2, int n) {
        this.heightOffset = 0.0f;
        this.lx = d;
        this.ly = d2;
        this.lz = d3;
        this.lyr = f;
        this.lxr = f2;
        this.lSteps = n;
    }

    public void superTick() {
        super.tick();
    }

    public void tick() {
        boolean bl;
        float f;
        float f2;
        super.tick();
        this.aiStep();
        double d = this.x - this.xo;
        double d2 = this.z - this.zo;
        float f3 = Mth.sqrt(d * d + d2 * d2);
        float f4 = this.yBodyRot;
        float f5 = 0.0f;
        this.oRun = this.run;
        float f6 = 0.0f;
        if (!(f3 <= 0.05f)) {
            f6 = 1.0f;
            f5 = f3 * 3.0f;
            f4 = (float)Math.atan2(d2, d) * 180.0f / (float)Math.PI - 90.0f;
        }
        if (this.attackAnim > 0.0f) {
            f4 = this.yRot;
        }
        if (!this.onGround) {
            f6 = 0.0f;
        }
        this.run += (f6 - this.run) * 0.3f;
        for (f2 = f4 - this.yBodyRot; f2 < -180.0f; f2 += 360.0f) {
        }
        while (f2 >= 180.0f) {
            f2 -= 360.0f;
        }
        this.yBodyRot += f2 * 0.3f;
        for (f = this.yRot - this.yBodyRot; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        boolean bl2 = bl = f < -90.0f || f >= 90.0f;
        if (f < -75.0f) {
            f = -75.0f;
        }
        if (f >= 75.0f) {
            f = 75.0f;
        }
        this.yBodyRot = this.yRot - f;
        if (f * f > 2500.0f) {
            this.yBodyRot += f * 0.2f;
        }
        if (bl) {
            f5 *= -1.0f;
        }
        while (this.yRot - this.yRotO < -180.0f) {
            this.yRotO -= 360.0f;
        }
        while (this.yRot - this.yRotO >= 180.0f) {
            this.yRotO += 360.0f;
        }
        while (this.yBodyRot - this.yBodyRotO < -180.0f) {
            this.yBodyRotO -= 360.0f;
        }
        while (this.yBodyRot - this.yBodyRotO >= 180.0f) {
            this.yBodyRotO += 360.0f;
        }
        while (this.xRot - this.xRotO < -180.0f) {
            this.xRotO -= 360.0f;
        }
        while (this.xRot - this.xRotO >= 180.0f) {
            this.xRotO += 360.0f;
        }
        this.animStep += f5;
    }

    protected void setSize(float f, float f2) {
        super.setSize(f, f2);
    }

    public void heal(int n) {
        if (this.health <= 0) {
            return;
        }
        this.health += n;
        if (this.health > 20) {
            this.health = 20;
        }
        this.invulnerableTime = this.invulnerableDuration / 2;
    }

    public boolean hurt(Entity entity, int n) {
        if (this.level.isOnline) {
            return false;
        }
        this.noActionTime = 0;
        if (this.health <= 0) {
            return false;
        }
        this.walkAnimSpeed = 1.5f;
        boolean bl = true;
        if ((float)this.invulnerableTime > (float)this.invulnerableDuration / 2.0f) {
            if (n <= this.lastHurt) {
                return false;
            }
            this.actuallyHurt(n - this.lastHurt);
            this.lastHurt = n;
            bl = false;
        } else {
            this.lastHurt = n;
            this.lastHealth = this.health;
            this.invulnerableTime = this.invulnerableDuration;
            this.actuallyHurt(n);
            this.hurtDuration = 10;
            this.hurtTime = 10;
        }
        this.hurtDir = 0.0f;
        if (bl) {
            this.level.broadcastEntityEvent(this, (byte)2);
            this.markHurt();
            if (entity != null) {
                double d = entity.x - this.x;
                double d2 = entity.z - this.z;
                while (d * d + d2 * d2 < 1.0E-4) {
                    d = (Math.random() - Math.random()) * 0.01;
                    d2 = (Math.random() - Math.random()) * 0.01;
                }
                this.hurtDir = (float)(Math.atan2(d2, d) * 180.0 / 3.1415927410125732) - this.yRot;
                this.knockback(entity, n, d, d2);
            } else {
                this.hurtDir = (int)(Math.random() * 2.0) * 180;
            }
        }
        if (this.health <= 0) {
            if (bl) {
                this.level.playSound(this, this.getDeathSound(), this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            }
            this.die(entity);
        } else if (bl) {
            this.level.playSound(this, this.getHurtSound(), this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
        return true;
    }

    public void animateHurt() {
        this.hurtDuration = 10;
        this.hurtTime = 10;
        this.hurtDir = 0.0f;
    }

    protected void actuallyHurt(int n) {
        this.health -= n;
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    protected String getAmbientSound() {
        return null;
    }

    protected String getHurtSound() {
        return "random.hurt";
    }

    protected String getDeathSound() {
        return "random.hurt";
    }

    public void knockback(Entity entity, int n, double d, double d2) {
        float f = Mth.sqrt(d * d + d2 * d2);
        float f2 = 0.4f;
        this.xd /= 2.0;
        this.yd /= 2.0;
        this.zd /= 2.0;
        this.xd -= d / (double)f * (double)f2;
        this.yd += (double)0.4f;
        this.zd -= d2 / (double)f * (double)f2;
        if (this.yd > (double)0.4f) {
            this.yd = 0.4f;
        }
    }

    public void die(Entity entity) {
        if (this.deathScore > 0 && entity != null) {
            entity.awardKillScore(this, this.deathScore);
        }
        this.dead = true;
        if (!this.level.isOnline) {
            this.dropDeathLoot();
        }
        this.level.broadcastEntityEvent(this, (byte)3);
    }

    protected void dropDeathLoot() {
        int n = this.getDeathLoot();
        if (n > 0) {
            int n2 = this.random.nextInt(3);
            for (int i = 0; i < n2; ++i) {
                this.spawnAtLocation(n, 1);
            }
        }
    }

    protected int getDeathLoot() {
        return 0;
    }

    protected void causeFallDamage(float f) {
        int n = (int)Math.ceil(f - 3.0f);
        if (n > 0) {
            this.hurt(null, n);
            int n2 = this.level.getTile(Mth.floor(this.x), Mth.floor(this.y - (double)0.2f - (double)this.heightOffset), Mth.floor(this.z));
            if (n2 > 0) {
                Tile.SoundType soundType = Tile.tiles[n2].soundType;
                this.level.playSound(this, soundType.getStepSound(), soundType.getVolume() * 0.5f, soundType.getPitch() * 0.75f);
            }
        }
    }

    public void travel(float f, float f2) {
        if (this.isInWater()) {
            double d = this.y;
            this.moveRelative(f, f2, 0.02f);
            this.move(this.xd, this.yd, this.zd);
            this.xd *= (double)0.8f;
            this.yd *= (double)0.8f;
            this.zd *= (double)0.8f;
            this.yd -= 0.02;
            if (this.horizontalCollision && this.isFree(this.xd, this.yd + (double)0.6f - this.y + d, this.zd)) {
                this.yd = 0.3f;
            }
        } else if (this.isInLava()) {
            double d = this.y;
            this.moveRelative(f, f2, 0.02f);
            this.move(this.xd, this.yd, this.zd);
            this.xd *= 0.5;
            this.yd *= 0.5;
            this.zd *= 0.5;
            this.yd -= 0.02;
            if (this.horizontalCollision && this.isFree(this.xd, this.yd + (double)0.6f - this.y + d, this.zd)) {
                this.yd = 0.3f;
            }
        } else {
            float f3 = 0.91f;
            if (this.onGround) {
                f3 = 0.54600006f;
                int n = this.level.getTile(Mth.floor(this.x), Mth.floor(this.bb.y0) - 1, Mth.floor(this.z));
                if (n > 0) {
                    f3 = Tile.tiles[n].friction * 0.91f;
                }
            }
            float f4 = 0.16277136f / (f3 * f3 * f3);
            this.moveRelative(f, f2, this.onGround ? 0.1f * f4 : 0.02f);
            f3 = 0.91f;
            if (this.onGround) {
                f3 = 0.54600006f;
                int n = this.level.getTile(Mth.floor(this.x), Mth.floor(this.bb.y0) - 1, Mth.floor(this.z));
                if (n > 0) {
                    f3 = Tile.tiles[n].friction * 0.91f;
                }
            }
            if (this.onLadder()) {
                this.fallDistance = 0.0f;
                if (this.yd < -0.15) {
                    this.yd = -0.15;
                }
            }
            this.move(this.xd, this.yd, this.zd);
            if (this.horizontalCollision && this.onLadder()) {
                this.yd = 0.2;
            }
            this.yd -= 0.08;
            this.yd *= (double)0.98f;
            this.xd *= (double)f3;
            this.zd *= (double)f3;
        }
        this.walkAnimSpeedO = this.walkAnimSpeed;
        double d = this.x - this.xo;
        double d2 = this.z - this.zo;
        float f5 = Mth.sqrt(d * d + d2 * d2) * 4.0f;
        if (f5 > 1.0f) {
            f5 = 1.0f;
        }
        this.walkAnimSpeed += (f5 - this.walkAnimSpeed) * 0.4f;
        this.walkAnimPos += this.walkAnimSpeed;
    }

    public boolean onLadder() {
        int n;
        int n2;
        int n3 = Mth.floor(this.x);
        return this.level.getTile(n3, n2 = Mth.floor(this.bb.y0), n = Mth.floor(this.z)) == Tile.ladder.id || this.level.getTile(n3, n2 + 1, n) == Tile.ladder.id;
    }

    public boolean isShootable() {
        return true;
    }

    public void addAdditonalSaveData(CompoundTag compoundTag) {
        compoundTag.putShort("Health", (short)this.health);
        compoundTag.putShort("HurtTime", (short)this.hurtTime);
        compoundTag.putShort("DeathTime", (short)this.deathTime);
        compoundTag.putShort("AttackTime", (short)this.attackTime);
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        this.health = compoundTag.getShort("Health");
        if (!compoundTag.contains("Health")) {
            this.health = 10;
        }
        this.hurtTime = compoundTag.getShort("HurtTime");
        this.deathTime = compoundTag.getShort("DeathTime");
        this.attackTime = compoundTag.getShort("AttackTime");
    }

    public boolean isAlive() {
        return !this.removed && this.health > 0;
    }

    public boolean isWaterMob() {
        return false;
    }

    public void aiStep() {
        if (this.lSteps > 0) {
            double d;
            double d2 = this.x + (this.lx - this.x) / (double)this.lSteps;
            double d3 = this.y + (this.ly - this.y) / (double)this.lSteps;
            double d4 = this.z + (this.lz - this.z) / (double)this.lSteps;
            for (d = this.lyr - (double)this.yRot; d < -180.0; d += 360.0) {
            }
            while (d >= 180.0) {
                d -= 360.0;
            }
            this.yRot = (float)((double)this.yRot + d / (double)this.lSteps);
            this.xRot = (float)((double)this.xRot + (this.lxr - (double)this.xRot) / (double)this.lSteps);
            --this.lSteps;
            this.setPos(d2, d3, d4);
            this.setRot(this.yRot, this.xRot);
        }
        if (this.health <= 0) {
            this.jumping = false;
            this.xxa = 0.0f;
            this.yya = 0.0f;
            this.yRotA = 0.0f;
        } else if (!this.interpolateOnly) {
            this.updateAi();
        }
        boolean bl = this.isInWater();
        boolean bl2 = this.isInLava();
        if (this.jumping) {
            if (bl) {
                this.yd += (double)0.04f;
            } else if (bl2) {
                this.yd += (double)0.04f;
            } else if (this.onGround) {
                this.jumpFromGround();
            }
        }
        this.xxa *= 0.98f;
        this.yya *= 0.98f;
        this.yRotA *= 0.9f;
        this.travel(this.xxa, this.yya);
        List<Entity> list = this.level.getEntities(this, this.bb.grow(0.2f, 0.0, 0.2f));
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = list.get(i);
                if (!entity.isPushable()) continue;
                entity.push(this);
            }
        }
    }

    protected void jumpFromGround() {
        this.yd = 0.42f;
    }

    protected void updateAi() {
        ++this.noActionTime;
        Player player = this.level.getNearestPlayer(this, -1.0);
        if (player != null) {
            double d = player.x - this.x;
            double d2 = player.y - this.y;
            double d3 = player.z - this.z;
            double d4 = d * d + d2 * d2 + d3 * d3;
            if (d4 > 16384.0) {
                this.remove();
            }
            if (this.noActionTime > 600 && this.random.nextInt(800) == 0) {
                if (d4 < 1024.0) {
                    this.noActionTime = 0;
                } else {
                    this.remove();
                }
            }
        }
        this.xxa = 0.0f;
        this.yya = 0.0f;
        float f = 8.0f;
        if (this.random.nextFloat() < 0.02f) {
            player = this.level.getNearestPlayer(this, f);
            if (player != null) {
                this.lookingAt = player;
                this.lookTime = 10 + this.random.nextInt(20);
            } else {
                this.yRotA = (this.random.nextFloat() - 0.5f) * 20.0f;
            }
        }
        if (this.lookingAt != null) {
            this.lookAt(this.lookingAt, 10.0f);
            if (this.lookTime-- <= 0 || this.lookingAt.removed || this.lookingAt.distanceToSqr(this) > (double)(f * f)) {
                this.lookingAt = null;
            }
        } else {
            if (this.random.nextFloat() < 0.05f) {
                this.yRotA = (this.random.nextFloat() - 0.5f) * 20.0f;
            }
            this.yRot += this.yRotA;
            this.xRot = this.defaultLookAngle;
        }
        boolean bl = this.isInWater();
        boolean bl2 = this.isInLava();
        if (bl || bl2) {
            this.jumping = this.random.nextFloat() < 0.8f;
        }
    }

    public void lookAt(Entity entity, float f) {
        double d;
        double d2 = entity.x - this.x;
        double d3 = entity.z - this.z;
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            d = mob.y + (double)mob.getHeadHeight() - (this.y + (double)this.getHeadHeight());
        } else {
            d = (entity.bb.y0 + entity.bb.y1) / 2.0 - (this.y + (double)this.getHeadHeight());
        }
        double d4 = Mth.sqrt(d2 * d2 + d3 * d3);
        float f2 = (float)(Math.atan2(d3, d2) * 180.0 / 3.1415927410125732) - 90.0f;
        float f3 = (float)(Math.atan2(d, d4) * 180.0 / 3.1415927410125732);
        this.xRot = -this.rotlerp(this.xRot, f3, f);
        this.yRot = this.rotlerp(this.yRot, f2, f);
    }

    private float rotlerp(float f, float f2, float f3) {
        float f4;
        for (f4 = f2 - f; f4 < -180.0f; f4 += 360.0f) {
        }
        while (f4 >= 180.0f) {
            f4 -= 360.0f;
        }
        if (f4 > f3) {
            f4 = f3;
        }
        if (f4 < -f3) {
            f4 = -f3;
        }
        return f + f4;
    }

    public void beforeRemove() {
    }

    public boolean canSpawn() {
        return this.level.isUnobstructed(this.bb) && this.level.getCubes(this, this.bb).size() == 0 && !this.level.containsAnyLiquid(this.bb);
    }

    protected void outOfWorld() {
        this.hurt(null, 4);
    }

    public float getAttackAnim(float f) {
        float f2 = this.attackAnim - this.oAttackAnim;
        if (f2 < 0.0f) {
            f2 += 1.0f;
        }
        return this.oAttackAnim + f2 * f;
    }

    public Vec3 getPos(float f) {
        if (f == 1.0f) {
            return Vec3.newTemp(this.x, this.y, this.z);
        }
        double d = this.xo + (this.x - this.xo) * (double)f;
        double d2 = this.yo + (this.y - this.yo) * (double)f;
        double d3 = this.zo + (this.z - this.zo) * (double)f;
        return Vec3.newTemp(d, d2, d3);
    }

    public Vec3 getLookAngle() {
        return this.getViewVector(1.0f);
    }

    public Vec3 getViewVector(float f) {
        if (f == 1.0f) {
            float f2 = Mth.cos(-this.yRot * ((float)Math.PI / 180) - (float)Math.PI);
            float f3 = Mth.sin(-this.yRot * ((float)Math.PI / 180) - (float)Math.PI);
            float f4 = -Mth.cos(-this.xRot * ((float)Math.PI / 180));
            float f5 = Mth.sin(-this.xRot * ((float)Math.PI / 180));
            return Vec3.newTemp(f3 * f4, f5, f2 * f4);
        }
        float f6 = this.xRotO + (this.xRot - this.xRotO) * f;
        float f7 = this.yRotO + (this.yRot - this.yRotO) * f;
        float f8 = Mth.cos(-f7 * ((float)Math.PI / 180) - (float)Math.PI);
        float f9 = Mth.sin(-f7 * ((float)Math.PI / 180) - (float)Math.PI);
        float f10 = -Mth.cos(-f6 * ((float)Math.PI / 180));
        float f11 = Mth.sin(-f6 * ((float)Math.PI / 180));
        return Vec3.newTemp(f9 * f10, f11, f8 * f10);
    }

    public HitResult pick(double d, float f) {
        Vec3 vec3 = this.getPos(f);
        Vec3 vec32 = this.getViewVector(f);
        Vec3 vec33 = vec3.add(vec32.x * d, vec32.y * d, vec32.z * d);
        return this.level.clip(vec3, vec33);
    }

    public int getMaxSpawnClusterSize() {
        return 4;
    }

    public ItemInstance getCarriedItem() {
        return null;
    }

    public void handleEntityEvent(byte by) {
        if (by == 2) {
            this.walkAnimSpeed = 1.5f;
            this.invulnerableTime = this.invulnerableDuration;
            this.hurtDuration = 10;
            this.hurtTime = 10;
            this.hurtDir = 0.0f;
            this.level.playSound(this, this.getHurtSound(), this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            this.hurt(null, 0);
        } else if (by == 3) {
            this.level.playSound(this, this.getDeathSound(), this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            this.health = 0;
            this.die(null);
        } else {
            super.handleEntityEvent(by);
        }
    }
}

