/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.tile.Tile;
import util.Mth;

public class FlyingMob
extends Mob {
    public FlyingMob(Level level) {
        super(level);
    }

    protected void causeFallDamage(float f) {
    }

    public void travel(float f, float f2) {
        if (this.isInWater()) {
            this.moveRelative(f, f2, 0.02f);
            this.move(this.xd, this.yd, this.zd);
            this.xd *= (double)0.8f;
            this.yd *= (double)0.8f;
            this.zd *= (double)0.8f;
        } else if (this.isInLava()) {
            this.moveRelative(f, f2, 0.02f);
            this.move(this.xd, this.yd, this.zd);
            this.xd *= 0.5;
            this.yd *= 0.5;
            this.zd *= 0.5;
        } else {
            float f3 = 0.91f;
            if (this.onGround) {
                f3 = 0.54600006f;
                int n = this.level.getTile(Mth.floor(this.x), Mth.floor(this.bb.y0) - 1, Mth.floor(this.z));
                if (n > 0) {
                    f3 = Tile.tiles[n].friction * 0.91f;
                }
            }
            float f4 = 0.16277136f / (f3 * f3 * f3);
            this.moveRelative(f, f2, this.onGround ? 0.1f * f4 : 0.02f);
            f3 = 0.91f;
            if (this.onGround) {
                f3 = 0.54600006f;
                int n = this.level.getTile(Mth.floor(this.x), Mth.floor(this.bb.y0) - 1, Mth.floor(this.z));
                if (n > 0) {
                    f3 = Tile.tiles[n].friction * 0.91f;
                }
            }
            this.move(this.xd, this.yd, this.zd);
            this.xd *= (double)f3;
            this.yd *= (double)f3;
            this.zd *= (double)f3;
        }
        this.walkAnimSpeedO = this.walkAnimSpeed;
        double d = this.x - this.xo;
        double d2 = this.z - this.zo;
        float f5 = Mth.sqrt(d * d + d2 * d2) * 4.0f;
        if (f5 > 1.0f) {
            f5 = 1.0f;
        }
        this.walkAnimSpeed += (f5 - this.walkAnimSpeed) * 0.4f;
        this.walkAnimPos += this.walkAnimSpeed;
    }

    public boolean onLadder() {
        return false;
    }
}

