/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.world.entity.Entity;

public class EntityPos {
    public double x;
    public double y;
    public double z;
    public float yRot;
    public float xRot;
    public boolean rot = false;
    public boolean move = false;

    public EntityPos(double d, double d2, double d3, float f, float f2) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.yRot = f;
        this.xRot = f2;
        this.rot = true;
        this.move = true;
    }

    public EntityPos(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.move = true;
        this.rot = false;
    }

    public EntityPos(float f, float f2) {
        this.yRot = f;
        this.xRot = f2;
        this.rot = true;
        this.move = false;
    }

    public EntityPos lerp(Entity entity, float f) {
        float f2;
        float f3;
        double d = entity.x + (this.x - entity.x) * (double)f;
        double d2 = entity.y + (this.y - entity.y) * (double)f;
        double d3 = entity.z + (this.z - entity.z) * (double)f;
        float f4 = this.xRot - entity.xRot;
        for (f3 = this.yRot - entity.yRot; f3 >= 180.0f; f3 -= 360.0f) {
        }
        while (f3 < -180.0f) {
            f3 += 360.0f;
        }
        while (f4 >= 180.0f) {
            f4 -= 360.0f;
        }
        while (f4 < -180.0f) {
            f4 += 360.0f;
        }
        float f5 = entity.xRot + f4 * f;
        for (f2 = entity.yRot + f3 * f; f2 >= 180.0f; f2 -= 360.0f) {
        }
        while (f2 < -180.0f) {
            f2 += 360.0f;
        }
        while (f5 >= 180.0f) {
            f5 -= 360.0f;
        }
        while (f5 < -180.0f) {
            f5 += 360.0f;
        }
        if (this.rot && this.move) {
            return new EntityPos(d, d2, d3, f2, f5);
        }
        if (this.move) {
            return new EntityPos(d, d2, d3);
        }
        if (this.rot) {
            return new EntityPos(f2, f5);
        }
        return null;
    }
}

