/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.nbt.CompoundTag;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Painting;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.item.Boat;
import net.minecraft.world.entity.item.FallingTile;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.Minecart;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Giant;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.PigZombie;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.level.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityIO {
    private static Map<String, Class<? extends Entity>> idClassMap = new HashMap<String, Class<? extends Entity>>();
    private static Map<Class<? extends Entity>, String> classIdMap = new HashMap<Class<? extends Entity>, String>();
    private static Map<Integer, Class<? extends Entity>> numClassMap = new HashMap<Integer, Class<? extends Entity>>();
    private static Map<Class<? extends Entity>, Integer> classNumMap = new HashMap<Class<? extends Entity>, Integer>();

    private static void setId(Class<? extends Entity> clazz, String string, int n) {
        idClassMap.put(string, clazz);
        classIdMap.put(clazz, string);
        numClassMap.put(n, clazz);
        classNumMap.put(clazz, n);
    }

    public static Entity newEntity(String string, Level level) {
        Entity entity = null;
        try {
            Class<? extends Entity> clazz = idClassMap.get(string);
            if (clazz != null) {
                entity = clazz.getConstructor(Level.class).newInstance(level);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return entity;
    }

    public static Entity loadStatic(CompoundTag compoundTag, Level level) {
        Entity entity = null;
        try {
            Class<? extends Entity> clazz = idClassMap.get(compoundTag.getString("id"));
            if (clazz != null) {
                entity = clazz.getConstructor(Level.class).newInstance(level);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (entity != null) {
            entity.load(compoundTag);
        } else {
            System.out.println("Skipping Entity with id " + compoundTag.getString("id"));
        }
        return entity;
    }

    public static Entity newById(int n, Level level) {
        Entity entity = null;
        try {
            Class<? extends Entity> clazz = numClassMap.get(n);
            if (clazz != null) {
                entity = clazz.getConstructor(Level.class).newInstance(level);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (entity == null) {
            System.out.println("Skipping Entity with id " + n);
        }
        return entity;
    }

    public static int getId(Entity entity) {
        return classNumMap.get(entity.getClass());
    }

    public static String getEncodeId(Entity entity) {
        return classIdMap.get(entity.getClass());
    }

    static {
        EntityIO.setId(Arrow.class, "Arrow", 10);
        EntityIO.setId(Snowball.class, "Snowball", 11);
        EntityIO.setId(ItemEntity.class, "Item", 1);
        EntityIO.setId(Painting.class, "Painting", 9);
        EntityIO.setId(Mob.class, "Mob", 48);
        EntityIO.setId(Monster.class, "Monster", 49);
        EntityIO.setId(Creeper.class, "Creeper", 50);
        EntityIO.setId(Skeleton.class, "Skeleton", 51);
        EntityIO.setId(Spider.class, "Spider", 52);
        EntityIO.setId(Giant.class, "Giant", 53);
        EntityIO.setId(Zombie.class, "Zombie", 54);
        EntityIO.setId(Slime.class, "Slime", 55);
        EntityIO.setId(Ghast.class, "Ghast", 56);
        EntityIO.setId(PigZombie.class, "PigZombie", 57);
        EntityIO.setId(Pig.class, "Pig", 90);
        EntityIO.setId(Sheep.class, "Sheep", 91);
        EntityIO.setId(Cow.class, "Cow", 92);
        EntityIO.setId(Chicken.class, "Chicken", 93);
        EntityIO.setId(Squid.class, "Squid", 94);
        EntityIO.setId(PrimedTnt.class, "PrimedTnt", 20);
        EntityIO.setId(FallingTile.class, "FallingSand", 21);
        EntityIO.setId(Minecart.class, "Minecart", 40);
        EntityIO.setId(Boat.class, "Boat", 41);
    }
}

