/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.DoubleTag;
import com.mojang.nbt.FloatTag;
import com.mojang.nbt.ListTag;
import com.mojang.nbt.Tag;
import java.util.List;
import java.util.Random;
import net.minecraft.world.entity.EntityIO;
import net.minecraft.world.entity.EntityPos;
import net.minecraft.world.entity.SynchedEntityData;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.LiquidTile;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import util.Mth;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Entity {
    public static final int TOTAL_AIR_SUPPLY = 300;
    private static int entityCounter = 0;
    public int entityId = entityCounter++;
    public double viewScale = 1.0;
    public boolean blocksBuilding = false;
    public Entity rider;
    public Entity riding;
    public Level level;
    public double xo;
    public double yo;
    public double zo;
    public double x;
    public double y;
    public double z;
    public double xd;
    public double yd;
    public double zd;
    public float yRot;
    public float xRot;
    public float yRotO;
    public float xRotO;
    public final AABB bb = AABB.newPermanent(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public boolean onGround = false;
    public boolean horizontalCollision;
    public boolean verticalCollision;
    public boolean collision = false;
    public boolean hurtMarked = false;
    public boolean slide = true;
    public boolean removed = false;
    public float heightOffset = 0.0f;
    public float bbWidth = 0.6f;
    public float bbHeight = 1.8f;
    public float walkDistO = 0.0f;
    public float walkDist = 0.0f;
    protected boolean makeStepSound = true;
    protected float fallDistance = 0.0f;
    private int nextStep = 1;
    public double xOld;
    public double yOld;
    public double zOld;
    public float ySlideOffset = 0.0f;
    public float footSize = 0.0f;
    public boolean noPhysics = false;
    public float pushthrough = 0.0f;
    public boolean hovered = false;
    protected Random random = new Random();
    public int tickCount = 0;
    public int flameTime = 1;
    public int onFire = 0;
    protected int airCapacity = 300;
    protected boolean wasInWater = false;
    public int invulnerableTime = 0;
    public int airSupply = 300;
    private boolean firstTick = true;
    public String customTextureUrl;
    public String customTextureUrl2;
    protected boolean fireImmune = false;
    protected SynchedEntityData entityData = new SynchedEntityData();
    private static final int DATA_SHARED_FLAGS_ID = 0;
    private static final int FLAG_ONFIRE = 0;
    private static final int FLAG_SNEAKING = 1;
    private static final int FLAG_RIDING = 2;
    private double xRideRotA;
    private double yRideRotA;
    public boolean inChunk = false;
    public int xChunk;
    public int yChunk;
    public int zChunk;
    public int xp;
    public int yp;
    public int zp;

    public Entity(Level level) {
        this.level = level;
        this.setPos(0.0, 0.0, 0.0);
        this.entityData.define(0, (byte)0);
        this.defineSynchedData();
    }

    protected abstract void defineSynchedData();

    public SynchedEntityData getEntityData() {
        return this.entityData;
    }

    public boolean equals(Object object) {
        if (object instanceof Entity) {
            return ((Entity)object).entityId == this.entityId;
        }
        return false;
    }

    public int hashCode() {
        return this.entityId;
    }

    protected void resetPos() {
        if (this.level == null) {
            return;
        }
        while (this.y > 0.0) {
            this.setPos(this.x, this.y, this.z);
            if (this.level.getCubes(this, this.bb).size() == 0) break;
            this.y += 1.0;
        }
        this.zd = 0.0;
        this.yd = 0.0;
        this.xd = 0.0;
        this.xRot = 0.0f;
    }

    public void remove() {
        this.removed = true;
    }

    protected void setSize(float f, float f2) {
        this.bbWidth = f;
        this.bbHeight = f2;
    }

    protected void setPos(EntityPos entityPos) {
        if (entityPos.move) {
            this.setPos(entityPos.x, entityPos.y, entityPos.z);
        } else {
            this.setPos(this.x, this.y, this.z);
        }
        if (entityPos.rot) {
            this.setRot(entityPos.yRot, entityPos.xRot);
        } else {
            this.setRot(this.yRot, this.xRot);
        }
    }

    protected void setRot(float f, float f2) {
        this.yRot = f;
        this.xRot = f2;
    }

    public void setPos(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        float f = this.bbWidth / 2.0f;
        float f2 = this.bbHeight;
        this.bb.set(d - (double)f, d2 - (double)this.heightOffset + (double)this.ySlideOffset, d3 - (double)f, d + (double)f, d2 - (double)this.heightOffset + (double)this.ySlideOffset + (double)f2, d3 + (double)f);
    }

    public void turn(float f, float f2) {
        float f3 = this.xRot;
        float f4 = this.yRot;
        this.yRot = (float)((double)this.yRot + (double)f * 0.15);
        this.xRot = (float)((double)this.xRot - (double)f2 * 0.15);
        if (this.xRot < -90.0f) {
            this.xRot = -90.0f;
        }
        if (this.xRot > 90.0f) {
            this.xRot = 90.0f;
        }
        this.xRotO += this.xRot - f3;
        this.yRotO += this.yRot - f4;
    }

    public void interpolateTurn(float f, float f2) {
        this.yRot = (float)((double)this.yRot + (double)f * 0.15);
        this.xRot = (float)((double)this.xRot - (double)f2 * 0.15);
        if (this.xRot < -90.0f) {
            this.xRot = -90.0f;
        }
        if (this.xRot > 90.0f) {
            this.xRot = 90.0f;
        }
    }

    public void tick() {
        this.baseTick();
    }

    public void baseTick() {
        if (this.riding != null && this.riding.removed) {
            this.riding = null;
        }
        ++this.tickCount;
        this.walkDistO = this.walkDist;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.xRotO = this.xRot;
        this.yRotO = this.yRot;
        if (this.isInWater()) {
            if (!this.wasInWater && !this.firstTick) {
                float f;
                float f2;
                float f3 = Mth.sqrt(this.xd * this.xd * (double)0.2f + this.yd * this.yd + this.zd * this.zd * (double)0.2f) * 0.2f;
                if (f3 > 1.0f) {
                    f3 = 1.0f;
                }
                this.level.playSound(this, "random.splash", f3, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                float f4 = Mth.floor(this.bb.y0);
                int n = 0;
                while ((float)n < 1.0f + this.bbWidth * 20.0f) {
                    f2 = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
                    f = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
                    this.level.addParticle("bubble", this.x + (double)f2, f4 + 1.0f, this.z + (double)f, this.xd, this.yd - (double)(this.random.nextFloat() * 0.2f), this.zd);
                    ++n;
                }
                n = 0;
                while ((float)n < 1.0f + this.bbWidth * 20.0f) {
                    f2 = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
                    f = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
                    this.level.addParticle("splash", this.x + (double)f2, f4 + 1.0f, this.z + (double)f, this.xd, this.yd, this.zd);
                    ++n;
                }
            }
            this.fallDistance = 0.0f;
            this.wasInWater = true;
            this.onFire = 0;
        } else {
            this.wasInWater = false;
        }
        if (this.level.isOnline) {
            this.onFire = 0;
        } else if (this.onFire > 0) {
            if (this.fireImmune) {
                this.onFire -= 4;
                if (this.onFire < 0) {
                    this.onFire = 0;
                }
            } else {
                if (this.onFire % 20 == 0) {
                    this.hurt(null, 1);
                }
                --this.onFire;
            }
        }
        if (this.isInLava()) {
            this.lavaHurt();
        }
        if (this.y < -64.0) {
            this.outOfWorld();
        }
        if (!this.level.isOnline) {
            this.setSharedFlag(0, this.onFire > 0);
            this.setSharedFlag(2, this.riding != null);
        }
        this.firstTick = false;
    }

    protected void lavaHurt() {
        if (!this.fireImmune) {
            this.hurt(null, 4);
            this.onFire = 600;
        }
    }

    protected void outOfWorld() {
        this.remove();
    }

    public boolean isFree(float f, float f2, float f3, float f4) {
        AABB aABB = this.bb.grow(f4, f4, f4).cloneMove(f, f2, f3);
        List<AABB> list = this.level.getCubes(this, aABB);
        if (list.size() > 0) {
            return false;
        }
        return !this.level.containsAnyLiquid(aABB);
    }

    public boolean isFree(double d, double d2, double d3) {
        AABB aABB = this.bb.cloneMove(d, d2, d3);
        List<AABB> list = this.level.getCubes(this, aABB);
        if (list.size() > 0) {
            return false;
        }
        return !this.level.containsAnyLiquid(aABB);
    }

    public void move(double d, double d2, double d3) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        double d4;
        int n7;
        int n8;
        boolean bl;
        if (this.noPhysics) {
            this.bb.move(d, d2, d3);
            this.x = (this.bb.x0 + this.bb.x1) / 2.0;
            this.y = this.bb.y0 + (double)this.heightOffset - (double)this.ySlideOffset;
            this.z = (this.bb.z0 + this.bb.z1) / 2.0;
            return;
        }
        double d5 = this.x;
        double d6 = this.z;
        double d7 = d;
        double d8 = d2;
        double d9 = d3;
        AABB aABB = this.bb.copy();
        boolean bl2 = bl = this.onGround && this.isSneaking();
        if (bl) {
            double d10 = 0.05;
            while (d != 0.0 && this.level.getCubes(this, this.bb.cloneMove(d, -1.0, 0.0)).size() == 0) {
                d = d < d10 && d >= -d10 ? 0.0 : (d > 0.0 ? (d -= d10) : (d += d10));
                d7 = d;
            }
            while (d3 != 0.0 && this.level.getCubes(this, this.bb.cloneMove(0.0, -1.0, d3)).size() == 0) {
                d3 = d3 < d10 && d3 >= -d10 ? 0.0 : (d3 > 0.0 ? (d3 -= d10) : (d3 += d10));
                d9 = d3;
            }
        }
        List<AABB> list = this.level.getCubes(this, this.bb.expand(d, d2, d3));
        for (n8 = 0; n8 < list.size(); ++n8) {
            d2 = list.get(n8).clipYCollide(this.bb, d2);
        }
        this.bb.move(0.0, d2, 0.0);
        if (!this.slide && d8 != d2) {
            d3 = 0.0;
            d2 = 0.0;
            d = 0.0;
        }
        n8 = this.onGround || d8 != d2 && d8 < 0.0 ? 1 : 0;
        for (n7 = 0; n7 < list.size(); ++n7) {
            d = list.get(n7).clipXCollide(this.bb, d);
        }
        this.bb.move(d, 0.0, 0.0);
        if (!this.slide && d7 != d) {
            d3 = 0.0;
            d2 = 0.0;
            d = 0.0;
        }
        for (n7 = 0; n7 < list.size(); ++n7) {
            d3 = list.get(n7).clipZCollide(this.bb, d3);
        }
        this.bb.move(0.0, 0.0, d3);
        if (!this.slide && d9 != d3) {
            d3 = 0.0;
            d2 = 0.0;
            d = 0.0;
        }
        if (this.footSize > 0.0f && n8 != 0 && this.ySlideOffset < 0.05f && (d7 != d || d9 != d3)) {
            double d11 = d;
            d4 = d2;
            double d12 = d3;
            d = d7;
            d2 = this.footSize;
            d3 = d9;
            AABB aABB2 = this.bb.copy();
            this.bb.set(aABB);
            list = this.level.getCubes(this, this.bb.expand(d, d2, d3));
            for (n6 = 0; n6 < list.size(); ++n6) {
                d2 = list.get(n6).clipYCollide(this.bb, d2);
            }
            this.bb.move(0.0, d2, 0.0);
            if (!this.slide && d8 != d2) {
                d3 = 0.0;
                d2 = 0.0;
                d = 0.0;
            }
            for (n6 = 0; n6 < list.size(); ++n6) {
                d = list.get(n6).clipXCollide(this.bb, d);
            }
            this.bb.move(d, 0.0, 0.0);
            if (!this.slide && d7 != d) {
                d3 = 0.0;
                d2 = 0.0;
                d = 0.0;
            }
            for (n6 = 0; n6 < list.size(); ++n6) {
                d3 = list.get(n6).clipZCollide(this.bb, d3);
            }
            this.bb.move(0.0, 0.0, d3);
            if (!this.slide && d9 != d3) {
                d3 = 0.0;
                d2 = 0.0;
                d = 0.0;
            }
            if (d11 * d11 + d12 * d12 >= d * d + d3 * d3) {
                d = d11;
                d2 = d4;
                d3 = d12;
                this.bb.set(aABB2);
            } else {
                this.ySlideOffset = (float)((double)this.ySlideOffset + 0.5);
            }
        }
        this.x = (this.bb.x0 + this.bb.x1) / 2.0;
        this.y = this.bb.y0 + (double)this.heightOffset - (double)this.ySlideOffset;
        this.z = (this.bb.z0 + this.bb.z1) / 2.0;
        this.horizontalCollision = d7 != d || d9 != d3;
        this.verticalCollision = d8 != d2;
        this.onGround = d8 != d2 && d8 < 0.0;
        this.collision = this.horizontalCollision || this.verticalCollision;
        this.checkFallDamage(d2, this.onGround);
        if (d7 != d) {
            this.xd = 0.0;
        }
        if (d8 != d2) {
            this.yd = 0.0;
        }
        if (d9 != d3) {
            this.zd = 0.0;
        }
        double d13 = this.x - d5;
        d4 = this.z - d6;
        if (this.makeStepSound && !bl) {
            this.walkDist = (float)((double)this.walkDist + (double)Mth.sqrt(d13 * d13 + d4 * d4) * 0.6);
            int n9 = Mth.floor(this.x);
            n5 = Mth.floor(this.y - (double)0.2f - (double)this.heightOffset);
            int n10 = Mth.floor(this.z);
            n6 = this.level.getTile(n9, n5, n10);
            if (this.walkDist > (float)this.nextStep && n6 > 0) {
                ++this.nextStep;
                Tile.SoundType soundType = Tile.tiles[n6].soundType;
                if (this.level.getTile(n9, n5 + 1, n10) == Tile.topSnow.id) {
                    soundType = Tile.topSnow.soundType;
                    this.level.playSound(this, soundType.getStepSound(), soundType.getVolume() * 0.15f, soundType.getPitch());
                } else if (!Tile.tiles[n6].material.isLiquid()) {
                    this.level.playSound(this, soundType.getStepSound(), soundType.getVolume() * 0.15f, soundType.getPitch());
                }
                Tile.tiles[n6].stepOn(this.level, n9, n5, n10, this);
            }
        }
        if (this.level.hasChunksAt(n4 = Mth.floor(this.bb.x0), n5 = Mth.floor(this.bb.y0), n3 = Mth.floor(this.bb.z0), n6 = Mth.floor(this.bb.x1), n2 = Mth.floor(this.bb.y1), n = Mth.floor(this.bb.z1))) {
            for (int i = n4; i <= n6; ++i) {
                for (int j = n5; j <= n2; ++j) {
                    for (int k = n3; k <= n; ++k) {
                        int n11 = this.level.getTile(i, j, k);
                        if (n11 <= 0) continue;
                        Tile.tiles[n11].entityInside(this.level, i, j, k, this);
                    }
                }
            }
        }
        this.ySlideOffset *= 0.4f;
        n4 = this.isInWater() ? 1 : 0;
        if (this.level.containsFireTile(this.bb)) {
            this.burn(1);
            if (n4 == 0) {
                ++this.onFire;
                if (this.onFire == 0) {
                    this.onFire = 300;
                }
            }
        } else if (this.onFire <= 0) {
            this.onFire = -this.flameTime;
        }
        if (n4 != 0 && this.onFire > 0) {
            this.level.playSound(this, "random.fizz", 0.7f, 1.6f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
            this.onFire = -this.flameTime;
        }
    }

    protected void checkFallDamage(double d, boolean bl) {
        if (bl) {
            if (this.fallDistance > 0.0f) {
                this.causeFallDamage(this.fallDistance);
                this.fallDistance = 0.0f;
            }
        } else if (d < 0.0) {
            this.fallDistance = (float)((double)this.fallDistance - d);
        }
    }

    public AABB getCollideBox() {
        return null;
    }

    protected void burn(int n) {
        if (!this.fireImmune) {
            this.hurt(null, n);
        }
    }

    protected void causeFallDamage(float f) {
    }

    public boolean isInWater() {
        return this.level.checkAndHandleWater(this.bb.grow(0.0, -0.4f, 0.0), Material.water, this);
    }

    public boolean isUnderLiquid(Material material) {
        int n;
        int n2;
        double d = this.y + (double)this.getHeadHeight();
        int n3 = Mth.floor(this.x);
        int n4 = this.level.getTile(n3, n2 = Mth.floor(Mth.floor(d)), n = Mth.floor(this.z));
        if (n4 != 0 && Tile.tiles[n4].material == material) {
            float f = LiquidTile.getHeight(this.level.getData(n3, n2, n)) - 0.11111111f;
            float f2 = (float)(n2 + 1) - f;
            return d < (double)f2;
        }
        return false;
    }

    public float getHeadHeight() {
        return 0.0f;
    }

    public boolean isInLava() {
        return this.level.containsMaterial(this.bb.grow(-0.1f, -0.4f, -0.1f), Material.lava);
    }

    public void moveRelative(float f, float f2, float f3) {
        float f4 = Mth.sqrt(f * f + f2 * f2);
        if (f4 < 0.01f) {
            return;
        }
        if (f4 < 1.0f) {
            f4 = 1.0f;
        }
        f4 = f3 / f4;
        float f5 = Mth.sin(this.yRot * (float)Math.PI / 180.0f);
        float f6 = Mth.cos(this.yRot * (float)Math.PI / 180.0f);
        this.xd += (double)((f *= f4) * f6 - (f2 *= f4) * f5);
        this.zd += (double)(f2 * f6 + f * f5);
    }

    public float getBrightness(float f) {
        int n = Mth.floor(this.x);
        double d = (this.bb.y1 - this.bb.y0) * 0.66;
        int n2 = Mth.floor(this.y - (double)this.heightOffset + d);
        int n3 = Mth.floor(this.z);
        if (this.level.hasChunksAt(Mth.floor(this.bb.x0), Mth.floor(this.bb.y0), Mth.floor(this.bb.z0), Mth.floor(this.bb.x1), Mth.floor(this.bb.y1), Mth.floor(this.bb.z1))) {
            return this.level.getBrightness(n, n2, n3);
        }
        return 0.0f;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void absMoveTo(double d, double d2, double d3, float f, float f2) {
        this.xo = this.x = d;
        this.yo = this.y = d2;
        this.zo = this.z = d3;
        this.yRotO = this.yRot = f;
        this.xRotO = this.xRot = f2;
        this.ySlideOffset = 0.0f;
        double d4 = this.yRotO - f;
        if (d4 < -180.0) {
            this.yRotO += 360.0f;
        }
        if (d4 >= 180.0) {
            this.yRotO -= 360.0f;
        }
        this.setPos(this.x, this.y, this.z);
        this.setRot(f, f2);
    }

    public void moveTo(double d, double d2, double d3, float f, float f2) {
        this.xo = this.x = d;
        this.xOld = this.x;
        this.yo = this.y = d2 + (double)this.heightOffset;
        this.yOld = this.y;
        this.zo = this.z = d3;
        this.zOld = this.z;
        this.yRot = f;
        this.xRot = f2;
        this.setPos(this.x, this.y, this.z);
    }

    public float distanceTo(Entity entity) {
        float f = (float)(this.x - entity.x);
        float f2 = (float)(this.y - entity.y);
        float f3 = (float)(this.z - entity.z);
        return Mth.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    public double distanceToSqr(double d, double d2, double d3) {
        double d4 = this.x - d;
        double d5 = this.y - d2;
        double d6 = this.z - d3;
        return d4 * d4 + d5 * d5 + d6 * d6;
    }

    public double distanceTo(double d, double d2, double d3) {
        double d4 = this.x - d;
        double d5 = this.y - d2;
        double d6 = this.z - d3;
        return Mth.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
    }

    public double distanceToSqr(Entity entity) {
        double d = this.x - entity.x;
        double d2 = this.y - entity.y;
        double d3 = this.z - entity.z;
        return d * d + d2 * d2 + d3 * d3;
    }

    public void playerTouch(Player player) {
    }

    public void push(Entity entity) {
        if (entity.rider == this || entity.riding == this) {
            return;
        }
        double d = entity.x - this.x;
        double d2 = entity.z - this.z;
        double d3 = Mth.asbMax(d, d2);
        if (d3 >= (double)0.01f) {
            d3 = Mth.sqrt(d3);
            d /= d3;
            d2 /= d3;
            double d4 = 1.0 / d3;
            if (d4 > 1.0) {
                d4 = 1.0;
            }
            d *= d4;
            d2 *= d4;
            d *= (double)0.05f;
            d2 *= (double)0.05f;
            this.push(-(d *= (double)(1.0f - this.pushthrough)), 0.0, -(d2 *= (double)(1.0f - this.pushthrough)));
            entity.push(d, 0.0, d2);
        }
    }

    public void push(double d, double d2, double d3) {
        this.xd += d;
        this.yd += d2;
        this.zd += d3;
    }

    protected void markHurt() {
        this.hurtMarked = true;
    }

    public boolean hurt(Entity entity, int n) {
        this.markHurt();
        return false;
    }

    public boolean intersects(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.bb.intersects(d, d2, d3, d4, d5, d6);
    }

    public boolean isPickable() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean isShootable() {
        return false;
    }

    public void awardKillScore(Entity entity, int n) {
    }

    public boolean shouldRender(Vec3 vec3) {
        double d = this.x - vec3.x;
        double d2 = this.y - vec3.y;
        double d3 = this.z - vec3.z;
        double d4 = d * d + d2 * d2 + d3 * d3;
        return this.shouldRenderAtSqrDistance(d4);
    }

    public boolean shouldRenderAtSqrDistance(double d) {
        double d2 = this.bb.getSize();
        return d < (d2 *= 64.0 * this.viewScale) * d2;
    }

    public String getTexture() {
        return null;
    }

    public boolean isCreativeModeAllowed() {
        return false;
    }

    public boolean save(CompoundTag compoundTag) {
        String string = this.getEncodeId();
        if (this.removed || string == null) {
            return false;
        }
        compoundTag.putString("id", string);
        this.saveWithoutId(compoundTag);
        return true;
    }

    public void saveWithoutId(CompoundTag compoundTag) {
        compoundTag.put("Pos", this.newDoubleList(this.x, this.y, this.z));
        compoundTag.put("Motion", this.newDoubleList(this.xd, this.yd, this.zd));
        compoundTag.put("Rotation", this.newFloatList(this.yRot, this.xRot));
        compoundTag.putFloat("FallDistance", this.fallDistance);
        compoundTag.putShort("Fire", (short)this.onFire);
        compoundTag.putShort("Air", (short)this.airSupply);
        compoundTag.putBoolean("OnGround", this.onGround);
        this.addAdditonalSaveData(compoundTag);
    }

    public void load(CompoundTag compoundTag) {
        ListTag<? extends Tag> listTag = compoundTag.getList("Pos");
        ListTag<? extends Tag> listTag2 = compoundTag.getList("Motion");
        ListTag<? extends Tag> listTag3 = compoundTag.getList("Rotation");
        this.setPos(0.0, 0.0, 0.0);
        this.xd = ((DoubleTag)listTag2.get((int)0)).data;
        this.yd = ((DoubleTag)listTag2.get((int)1)).data;
        this.zd = ((DoubleTag)listTag2.get((int)2)).data;
        this.xOld = this.x = ((DoubleTag)listTag.get((int)0)).data;
        this.xo = this.x;
        this.yOld = this.y = ((DoubleTag)listTag.get((int)1)).data;
        this.yo = this.y;
        this.zOld = this.z = ((DoubleTag)listTag.get((int)2)).data;
        this.zo = this.z;
        this.yRotO = this.yRot = ((FloatTag)listTag3.get((int)0)).data;
        this.xRotO = this.xRot = ((FloatTag)listTag3.get((int)1)).data;
        this.fallDistance = compoundTag.getFloat("FallDistance");
        this.onFire = compoundTag.getShort("Fire");
        this.airSupply = compoundTag.getShort("Air");
        this.onGround = compoundTag.getBoolean("OnGround");
        this.setPos(this.x, this.y, this.z);
        this.readAdditionalSaveData(compoundTag);
    }

    protected final String getEncodeId() {
        return EntityIO.getEncodeId(this);
    }

    protected abstract void readAdditionalSaveData(CompoundTag var1);

    protected abstract void addAdditonalSaveData(CompoundTag var1);

    protected ListTag<DoubleTag> newDoubleList(double ... dArray) {
        ListTag<DoubleTag> listTag = new ListTag<DoubleTag>();
        for (double d : dArray) {
            listTag.add(new DoubleTag(d));
        }
        return listTag;
    }

    protected ListTag<FloatTag> newFloatList(float ... fArray) {
        ListTag<FloatTag> listTag = new ListTag<FloatTag>();
        for (float f : fArray) {
            listTag.add(new FloatTag(f));
        }
        return listTag;
    }

    public float getShadowHeightOffs() {
        return this.bbHeight / 2.0f;
    }

    public ItemEntity spawnAtLocation(int n, int n2) {
        return this.spawnAtLocation(n, n2, 0.0f);
    }

    public ItemEntity spawnAtLocation(int n, int n2, float f) {
        return this.spawnAtLocation(new ItemInstance(n, n2, 0), f);
    }

    public ItemEntity spawnAtLocation(ItemInstance itemInstance, float f) {
        ItemEntity itemEntity = new ItemEntity(this.level, this.x, this.y + (double)f, this.z, itemInstance);
        itemEntity.throwTime = 10;
        this.level.addEntity(itemEntity);
        return itemEntity;
    }

    public boolean isAlive() {
        return !this.removed;
    }

    public boolean isInWall() {
        int n = Mth.floor(this.x);
        int n2 = Mth.floor(this.y + (double)this.getHeadHeight());
        int n3 = Mth.floor(this.z);
        return this.level.isSolidTile(n, n2, n3);
    }

    public boolean interact(Player player) {
        return false;
    }

    public AABB getCollideAgainstBox(Entity entity) {
        return null;
    }

    public void rideTick() {
        if (this.riding.removed) {
            this.riding = null;
            return;
        }
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.tick();
        this.riding.positionRider();
        this.yRideRotA += (double)(this.riding.yRot - this.riding.yRotO);
        this.xRideRotA += (double)(this.riding.xRot - this.riding.xRotO);
        while (this.yRideRotA >= 180.0) {
            this.yRideRotA -= 360.0;
        }
        while (this.yRideRotA < -180.0) {
            this.yRideRotA += 360.0;
        }
        while (this.xRideRotA >= 180.0) {
            this.xRideRotA -= 360.0;
        }
        while (this.xRideRotA < -180.0) {
            this.xRideRotA += 360.0;
        }
        double d = this.yRideRotA * 0.5;
        double d2 = this.xRideRotA * 0.5;
        float f = 10.0f;
        if (d > (double)f) {
            d = f;
        }
        if (d < (double)(-f)) {
            d = -f;
        }
        if (d2 > (double)f) {
            d2 = f;
        }
        if (d2 < (double)(-f)) {
            d2 = -f;
        }
        this.yRideRotA -= d;
        this.xRideRotA -= d2;
        this.yRot = (float)((double)this.yRot + d);
        this.xRot = (float)((double)this.xRot + d2);
    }

    public void positionRider() {
        this.rider.setPos(this.x, this.y + this.getRideHeight() + this.rider.getRidingHeight(), this.z);
    }

    public double getRidingHeight() {
        return this.heightOffset;
    }

    public double getRideHeight() {
        return (double)this.bbHeight * 0.75;
    }

    public void ride(Entity entity) {
        this.xRideRotA = 0.0;
        this.yRideRotA = 0.0;
        if (entity == null) {
            if (this.riding != null) {
                this.moveTo(this.riding.x, this.riding.bb.y0 + (double)this.riding.bbHeight, this.riding.z, this.yRot, this.xRot);
                this.riding.rider = null;
            }
            this.riding = null;
            return;
        }
        if (this.riding == entity) {
            this.riding.rider = null;
            this.riding = null;
            this.moveTo(entity.x, entity.bb.y0 + (double)entity.bbHeight, entity.z, this.yRot, this.xRot);
            return;
        }
        if (this.riding != null) {
            this.riding.rider = null;
        }
        if (entity.rider != null) {
            entity.rider.riding = null;
        }
        this.riding = entity;
        entity.rider = this;
    }

    public void lerpTo(double d, double d2, double d3, float f, float f2, int n) {
        this.setPos(d, d2, d3);
        this.setRot(f, f2);
    }

    public float getPickRadius() {
        return 0.1f;
    }

    public Vec3 getLookAngle() {
        return null;
    }

    public void handleInsidePortal() {
    }

    public void lerpMotion(double d, double d2, double d3) {
        this.xd = d;
        this.yd = d2;
        this.zd = d3;
    }

    public void handleEntityEvent(byte by) {
    }

    public void animateHurt() {
    }

    public void prepareCustomTextures() {
    }

    public ItemInstance[] getEquipmentSlots() {
        return null;
    }

    public void setEquippedSlot(int n, int n2, int n3) {
    }

    public boolean isOnFire() {
        return this.onFire > 0 || this.getSharedFlag(0);
    }

    public boolean isRiding() {
        return this.riding != null || this.getSharedFlag(2);
    }

    public boolean isSneaking() {
        return this.getSharedFlag(1);
    }

    public void setSneaking(boolean bl) {
        this.setSharedFlag(1, bl);
    }

    protected boolean getSharedFlag(int n) {
        return (this.entityData.getByte(0) & 1 << n) != 0;
    }

    protected void setSharedFlag(int n, boolean bl) {
        byte by = this.entityData.getByte(0);
        if (bl) {
            this.entityData.set(0, (byte)(by | 1 << n));
        } else {
            this.entityData.set(0, (byte)(by & ~(1 << n)));
        }
    }
}

