/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemInstance;

public class SimpleContainer
implements Container {
    private String name;
    private int size;
    private ItemInstance[] items;
    private List<ContainerListener> listeners;

    public SimpleContainer(String string, int n) {
        this.name = string;
        this.size = n;
        this.items = new ItemInstance[n];
    }

    public void addListener(ContainerListener containerListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ContainerListener>();
        }
        this.listeners.add(containerListener);
    }

    public void removeListener(ContainerListener containerListener) {
        this.listeners.remove(containerListener);
    }

    public ItemInstance getItem(int n) {
        return this.items[n];
    }

    public ItemInstance removeItem(int n, int n2) {
        if (this.items[n] != null) {
            if (this.items[n].count <= n2) {
                ItemInstance itemInstance = this.items[n];
                this.items[n] = null;
                this.setChanged();
                return itemInstance;
            }
            ItemInstance itemInstance = this.items[n].remove(n2);
            if (this.items[n].count == 0) {
                this.items[n] = null;
            }
            this.setChanged();
            return itemInstance;
        }
        return null;
    }

    public void setItem(int n, ItemInstance itemInstance) {
        this.items[n] = itemInstance;
        if (itemInstance != null && itemInstance.count > this.getMaxStackSize()) {
            itemInstance.count = this.getMaxStackSize();
        }
        this.setChanged();
    }

    public int getContainerSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public int getMaxStackSize() {
        return 64;
    }

    public void setChanged() {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).containerChanged(this);
            }
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }
}

