/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemInstance;

public class CompoundContainer
implements Container {
    private String name;
    private Container c1;
    private Container c2;

    public CompoundContainer(String string, Container container, Container container2) {
        this.name = string;
        this.c1 = container;
        this.c2 = container2;
    }

    public int getContainerSize() {
        return this.c1.getContainerSize() + this.c2.getContainerSize();
    }

    public String getName() {
        return this.name;
    }

    public ItemInstance getItem(int n) {
        if (n >= this.c1.getContainerSize()) {
            return this.c2.getItem(n - this.c1.getContainerSize());
        }
        return this.c1.getItem(n);
    }

    public ItemInstance removeItem(int n, int n2) {
        if (n >= this.c1.getContainerSize()) {
            return this.c2.removeItem(n - this.c1.getContainerSize(), n2);
        }
        return this.c1.removeItem(n, n2);
    }

    public void setItem(int n, ItemInstance itemInstance) {
        if (n >= this.c1.getContainerSize()) {
            this.c2.setItem(n - this.c1.getContainerSize(), itemInstance);
        } else {
            this.c1.setItem(n, itemInstance);
        }
    }

    public int getMaxStackSize() {
        return this.c1.getMaxStackSize();
    }

    public void setChanged() {
        this.c1.setChanged();
        this.c2.setChanged();
    }

    public boolean stillValid(Player player) {
        return this.c1.stillValid(player) && this.c2.stillValid(player);
    }
}

