/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.PacketListener;
import net.minecraft.world.item.ItemInstance;

public class UseItemPacket
extends Packet {
    public int x;
    public int y;
    public int z;
    public int face;
    public ItemInstance item;

    public UseItemPacket() {
    }

    public UseItemPacket(int n, int n2, int n3, int n4, ItemInstance itemInstance) {
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.face = n4;
        this.item = itemInstance;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.x = dataInputStream.readInt();
        this.y = dataInputStream.read();
        this.z = dataInputStream.readInt();
        this.face = dataInputStream.read();
        short s = dataInputStream.readShort();
        if (s >= 0) {
            byte by = dataInputStream.readByte();
            short s2 = dataInputStream.readShort();
            this.item = new ItemInstance(s, (int)by, (int)s2);
        } else {
            this.item = null;
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.x);
        dataOutputStream.write(this.y);
        dataOutputStream.writeInt(this.z);
        dataOutputStream.write(this.face);
        if (this.item == null) {
            dataOutputStream.writeShort(-1);
        } else {
            dataOutputStream.writeShort(this.item.id);
            dataOutputStream.writeByte(this.item.count);
            dataOutputStream.writeShort(this.item.getAuxValue());
        }
    }

    public void handle(PacketListener packetListener) {
        packetListener.handleUseItem(this);
    }

    public int getEstimatedSize() {
        return 15;
    }
}

