/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.PacketListener;
import net.minecraft.world.level.Level;

public class TileUpdatePacket
extends Packet {
    public int x;
    public int y;
    public int z;
    public int block;
    public int data;

    public TileUpdatePacket() {
        this.shouldDelay = true;
    }

    public TileUpdatePacket(int n, int n2, int n3, Level level) {
        this.shouldDelay = true;
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.block = level.getTile(n, n2, n3);
        this.data = level.getData(n, n2, n3);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.x = dataInputStream.readInt();
        this.y = dataInputStream.read();
        this.z = dataInputStream.readInt();
        this.block = dataInputStream.read();
        this.data = dataInputStream.read();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.x);
        dataOutputStream.write(this.y);
        dataOutputStream.writeInt(this.z);
        dataOutputStream.write(this.block);
        dataOutputStream.write(this.data);
    }

    public void handle(PacketListener packetListener) {
        packetListener.handleTileUpdate(this);
    }

    public int getEstimatedSize() {
        return 11;
    }
}

