/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.PacketListener;
import net.minecraft.world.entity.Entity;
import util.Mth;

public class TeleportEntityPacket
extends Packet {
    public int id;
    public int x;
    public int y;
    public int z;
    public byte yRot;
    public byte xRot;

    public TeleportEntityPacket() {
    }

    public TeleportEntityPacket(Entity entity) {
        this.id = entity.entityId;
        this.x = Mth.floor(entity.x * 32.0);
        this.y = Mth.floor(entity.y * 32.0);
        this.z = Mth.floor(entity.z * 32.0);
        this.yRot = (byte)(entity.yRot * 256.0f / 360.0f);
        this.xRot = (byte)(entity.xRot * 256.0f / 360.0f);
    }

    public TeleportEntityPacket(int n, int n2, int n3, int n4, byte by, byte by2) {
        this.id = n;
        this.x = n2;
        this.y = n3;
        this.z = n4;
        this.yRot = by;
        this.xRot = by2;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.id = dataInputStream.readInt();
        this.x = dataInputStream.readInt();
        this.y = dataInputStream.readInt();
        this.z = dataInputStream.readInt();
        this.yRot = (byte)dataInputStream.read();
        this.xRot = (byte)dataInputStream.read();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.id);
        dataOutputStream.writeInt(this.x);
        dataOutputStream.writeInt(this.y);
        dataOutputStream.writeInt(this.z);
        dataOutputStream.write(this.yRot);
        dataOutputStream.write(this.xRot);
    }

    public void handle(PacketListener packetListener) {
        packetListener.handleTeleportEntity(this);
    }

    public int getEstimatedSize() {
        return 34;
    }
}

