/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.PacketListener;

public class SignUpdatePacket
extends Packet {
    public int x;
    public int y;
    public int z;
    public String[] lines;

    public SignUpdatePacket() {
        this.shouldDelay = true;
    }

    public SignUpdatePacket(int n, int n2, int n3, String[] stringArray) {
        this.shouldDelay = true;
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.lines = stringArray;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.x = dataInputStream.readInt();
        this.y = dataInputStream.readShort();
        this.z = dataInputStream.readInt();
        this.lines = new String[4];
        for (int i = 0; i < 4; ++i) {
            this.lines[i] = dataInputStream.readUTF();
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.x);
        dataOutputStream.writeShort(this.y);
        dataOutputStream.writeInt(this.z);
        for (int i = 0; i < 4; ++i) {
            dataOutputStream.writeUTF(this.lines[i]);
        }
    }

    public void handle(PacketListener packetListener) {
        packetListener.handleSignUpdate(this);
    }

    public int getEstimatedSize() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n += this.lines[i].length();
        }
        return n;
    }
}

