/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.PacketListener;
import net.minecraft.world.item.ItemInstance;

public class SetEquippedItemPacket
extends Packet {
    public int entity;
    public int slot;
    public int item;
    public int auxValue;

    public SetEquippedItemPacket() {
    }

    public SetEquippedItemPacket(int n, int n2, ItemInstance itemInstance) {
        this.entity = n;
        this.slot = n2;
        if (itemInstance == null) {
            this.item = -1;
            this.auxValue = 0;
        } else {
            this.item = itemInstance.id;
            this.auxValue = itemInstance.getAuxValue();
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.entity = dataInputStream.readInt();
        this.slot = dataInputStream.readShort();
        this.item = dataInputStream.readShort();
        this.auxValue = dataInputStream.readShort();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.entity);
        dataOutputStream.writeShort(this.slot);
        dataOutputStream.writeShort(this.item);
        dataOutputStream.writeShort(this.auxValue);
    }

    public void handle(PacketListener packetListener) {
        packetListener.handleSetEquippedItem(this);
    }

    public int getEstimatedSize() {
        return 8;
    }
}

