/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.PacketListener;
import net.minecraft.world.entity.Entity;

public class SetEntityMotionPacket
extends Packet {
    public int id;
    public int xa;
    public int ya;
    public int za;

    public SetEntityMotionPacket() {
    }

    public SetEntityMotionPacket(Entity entity) {
        this(entity.entityId, entity.xd, entity.yd, entity.zd);
    }

    public SetEntityMotionPacket(int n, double d, double d2, double d3) {
        this.id = n;
        double d4 = 3.9;
        if (d < -d4) {
            d = -d4;
        }
        if (d2 < -d4) {
            d2 = -d4;
        }
        if (d3 < -d4) {
            d3 = -d4;
        }
        if (d > d4) {
            d = d4;
        }
        if (d2 > d4) {
            d2 = d4;
        }
        if (d3 > d4) {
            d3 = d4;
        }
        this.xa = (int)(d * 8000.0);
        this.ya = (int)(d2 * 8000.0);
        this.za = (int)(d3 * 8000.0);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.id = dataInputStream.readInt();
        this.xa = dataInputStream.readShort();
        this.ya = dataInputStream.readShort();
        this.za = dataInputStream.readShort();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.id);
        dataOutputStream.writeShort(this.xa);
        dataOutputStream.writeShort(this.ya);
        dataOutputStream.writeShort(this.za);
    }

    public void handle(PacketListener packetListener) {
        packetListener.handleSetEntityMotion(this);
    }

    public int getEstimatedSize() {
        return 10;
    }
}

