/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.PacketListener;
import net.minecraft.world.entity.SynchedEntityData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetEntityDataPacket
extends Packet {
    public int id;
    private List<SynchedEntityData.DataItem> packedItems;

    public SetEntityDataPacket() {
    }

    public SetEntityDataPacket(int n, SynchedEntityData synchedEntityData) {
        this.id = n;
        this.packedItems = synchedEntityData.packDirty();
    }

    @Override
    public void read(DataInputStream dataInputStream) throws IOException {
        this.id = dataInputStream.readInt();
        this.packedItems = SynchedEntityData.unpack(dataInputStream);
    }

    @Override
    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.id);
        SynchedEntityData.pack(this.packedItems, dataOutputStream);
    }

    @Override
    public void handle(PacketListener packetListener) {
        packetListener.handleSetEntityData(this);
    }

    @Override
    public int getEstimatedSize() {
        return 5;
    }

    public List<SynchedEntityData.DataItem> getUnpackedData() {
        return this.packedItems;
    }
}

