/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.PacketListener;
import net.minecraft.world.entity.Entity;

public class PlayerCommandPacket
extends Packet {
    public static final int START_SNEAKING = 1;
    public static final int STOP_SNEAKING = 2;
    public int id;
    public int action;

    public PlayerCommandPacket() {
    }

    public PlayerCommandPacket(Entity entity, int n) {
        this.id = entity.entityId;
        this.action = n;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.id = dataInputStream.readInt();
        this.action = dataInputStream.readByte();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.id);
        dataOutputStream.writeByte(this.action);
    }

    public void handle(PacketListener packetListener) {
        packetListener.handlePlayerCommand(this);
    }

    public int getEstimatedSize() {
        return 5;
    }
}

