/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.packet.AddEntityPacket;
import net.minecraft.network.packet.AddItemEntityPacket;
import net.minecraft.network.packet.AddMobPacket;
import net.minecraft.network.packet.AddPaintingPacket;
import net.minecraft.network.packet.AddPlayerPacket;
import net.minecraft.network.packet.AnimatePacket;
import net.minecraft.network.packet.BlockRegionUpdatePacket;
import net.minecraft.network.packet.ChatPacket;
import net.minecraft.network.packet.ChunkTilesUpdatePacket;
import net.minecraft.network.packet.ChunkVisibilityPacket;
import net.minecraft.network.packet.ContainerAckPacket;
import net.minecraft.network.packet.ContainerClickPacket;
import net.minecraft.network.packet.ContainerClosePacket;
import net.minecraft.network.packet.ContainerOpenPacket;
import net.minecraft.network.packet.ContainerSetContentPacket;
import net.minecraft.network.packet.ContainerSetDataPacket;
import net.minecraft.network.packet.ContainerSetSlotPacket;
import net.minecraft.network.packet.DisconnectPacket;
import net.minecraft.network.packet.EntityEventPacket;
import net.minecraft.network.packet.ExplodePacket;
import net.minecraft.network.packet.InteractPacket;
import net.minecraft.network.packet.KeepAlivePacket;
import net.minecraft.network.packet.LoginPacket;
import net.minecraft.network.packet.MoveEntityPacket;
import net.minecraft.network.packet.MovePlayerPacket;
import net.minecraft.network.packet.PacketListener;
import net.minecraft.network.packet.PlayerActionPacket;
import net.minecraft.network.packet.PlayerCommandPacket;
import net.minecraft.network.packet.PreLoginPacket;
import net.minecraft.network.packet.RemoveEntityPacket;
import net.minecraft.network.packet.RespawnPacket;
import net.minecraft.network.packet.SetCarriedItemPacket;
import net.minecraft.network.packet.SetEntityDataPacket;
import net.minecraft.network.packet.SetEntityMotionPacket;
import net.minecraft.network.packet.SetEquippedItemPacket;
import net.minecraft.network.packet.SetHealthPacket;
import net.minecraft.network.packet.SetRidingPacket;
import net.minecraft.network.packet.SetSpawnPositionPacket;
import net.minecraft.network.packet.SetTimePacket;
import net.minecraft.network.packet.SignUpdatePacket;
import net.minecraft.network.packet.TakeItemEntityPacket;
import net.minecraft.network.packet.TeleportEntityPacket;
import net.minecraft.network.packet.TileEventPacket;
import net.minecraft.network.packet.TileUpdatePacket;
import net.minecraft.network.packet.UseItemPacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Packet {
    private static Map<Integer, Class<? extends Packet>> idToClassMap = new HashMap<Integer, Class<? extends Packet>>();
    private static Map<Class<? extends Packet>, Integer> classToIdMap = new HashMap<Class<? extends Packet>, Integer>();
    public final long createTime = System.currentTimeMillis();
    public boolean shouldDelay = false;

    static void map(int n, Class<? extends Packet> clazz) {
        if (idToClassMap.containsKey(n)) {
            throw new IllegalArgumentException("Duplicate packet id:" + n);
        }
        if (classToIdMap.containsKey(clazz)) {
            throw new IllegalArgumentException("Duplicate packet class:" + clazz);
        }
        idToClassMap.put(n, clazz);
        classToIdMap.put(clazz, n);
    }

    public static Packet getPacket(int n) {
        try {
            Class<? extends Packet> clazz = idToClassMap.get(n);
            if (clazz == null) {
                return null;
            }
            return clazz.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Skipping packet with id " + n);
            return null;
        }
    }

    public final int getId() {
        return classToIdMap.get(this.getClass());
    }

    public static Packet readPacket(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.read();
        if (n == -1) {
            return null;
        }
        Packet packet = Packet.getPacket(n);
        if (packet == null) {
            throw new IOException("Bad packet id " + n);
        }
        packet.read(dataInputStream);
        return packet;
    }

    public static void writePacket(Packet packet, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(packet.getId());
        packet.write(dataOutputStream);
    }

    public abstract void read(DataInputStream var1) throws IOException;

    public abstract void write(DataOutputStream var1) throws IOException;

    public abstract void handle(PacketListener var1);

    public abstract int getEstimatedSize();

    static {
        Packet.map(0, KeepAlivePacket.class);
        Packet.map(1, LoginPacket.class);
        Packet.map(2, PreLoginPacket.class);
        Packet.map(3, ChatPacket.class);
        Packet.map(4, SetTimePacket.class);
        Packet.map(5, SetEquippedItemPacket.class);
        Packet.map(6, SetSpawnPositionPacket.class);
        Packet.map(7, InteractPacket.class);
        Packet.map(8, SetHealthPacket.class);
        Packet.map(9, RespawnPacket.class);
        Packet.map(10, MovePlayerPacket.class);
        Packet.map(11, MovePlayerPacket.Pos.class);
        Packet.map(12, MovePlayerPacket.Rot.class);
        Packet.map(13, MovePlayerPacket.PosRot.class);
        Packet.map(14, PlayerActionPacket.class);
        Packet.map(15, UseItemPacket.class);
        Packet.map(16, SetCarriedItemPacket.class);
        Packet.map(18, AnimatePacket.class);
        Packet.map(19, PlayerCommandPacket.class);
        Packet.map(20, AddPlayerPacket.class);
        Packet.map(21, AddItemEntityPacket.class);
        Packet.map(22, TakeItemEntityPacket.class);
        Packet.map(23, AddEntityPacket.class);
        Packet.map(24, AddMobPacket.class);
        Packet.map(25, AddPaintingPacket.class);
        Packet.map(28, SetEntityMotionPacket.class);
        Packet.map(29, RemoveEntityPacket.class);
        Packet.map(30, MoveEntityPacket.class);
        Packet.map(31, MoveEntityPacket.Pos.class);
        Packet.map(32, MoveEntityPacket.Rot.class);
        Packet.map(33, MoveEntityPacket.PosRot.class);
        Packet.map(34, TeleportEntityPacket.class);
        Packet.map(38, EntityEventPacket.class);
        Packet.map(39, SetRidingPacket.class);
        Packet.map(40, SetEntityDataPacket.class);
        Packet.map(50, ChunkVisibilityPacket.class);
        Packet.map(51, BlockRegionUpdatePacket.class);
        Packet.map(52, ChunkTilesUpdatePacket.class);
        Packet.map(53, TileUpdatePacket.class);
        Packet.map(54, TileEventPacket.class);
        Packet.map(60, ExplodePacket.class);
        Packet.map(100, ContainerOpenPacket.class);
        Packet.map(101, ContainerClosePacket.class);
        Packet.map(102, ContainerClickPacket.class);
        Packet.map(103, ContainerSetSlotPacket.class);
        Packet.map(104, ContainerSetContentPacket.class);
        Packet.map(105, ContainerSetDataPacket.class);
        Packet.map(106, ContainerAckPacket.class);
        Packet.map(130, SignUpdatePacket.class);
        Packet.map(255, DisconnectPacket.class);
    }
}

