/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.PacketListener;

public class MovePlayerPacket
extends Packet {
    public double x;
    public double y;
    public double z;
    public double yView;
    public float yRot;
    public float xRot;
    public boolean onGround;
    public boolean hasPos;
    public boolean hasRot;

    public MovePlayerPacket() {
    }

    public MovePlayerPacket(boolean bl) {
        this.onGround = bl;
    }

    public void handle(PacketListener packetListener) {
        packetListener.handleMovePlayer(this);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.onGround = dataInputStream.read() != 0;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(this.onGround ? 1 : 0);
    }

    public int getEstimatedSize() {
        return 1;
    }

    public static class Rot
    extends MovePlayerPacket {
        public Rot() {
            this.hasRot = true;
        }

        public Rot(float f, float f2, boolean bl) {
            this.yRot = f;
            this.xRot = f2;
            this.onGround = bl;
            this.hasRot = true;
        }

        public void read(DataInputStream dataInputStream) throws IOException {
            this.yRot = dataInputStream.readFloat();
            this.xRot = dataInputStream.readFloat();
            super.read(dataInputStream);
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeFloat(this.yRot);
            dataOutputStream.writeFloat(this.xRot);
            super.write(dataOutputStream);
        }

        public int getEstimatedSize() {
            return 9;
        }
    }

    public static class Pos
    extends MovePlayerPacket {
        public Pos() {
            this.hasPos = true;
        }

        public Pos(double d, double d2, double d3, double d4, boolean bl) {
            this.x = d;
            this.y = d2;
            this.yView = d3;
            this.z = d4;
            this.onGround = bl;
            this.hasPos = true;
        }

        public void read(DataInputStream dataInputStream) throws IOException {
            this.x = dataInputStream.readDouble();
            this.y = dataInputStream.readDouble();
            this.yView = dataInputStream.readDouble();
            this.z = dataInputStream.readDouble();
            super.read(dataInputStream);
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeDouble(this.x);
            dataOutputStream.writeDouble(this.y);
            dataOutputStream.writeDouble(this.yView);
            dataOutputStream.writeDouble(this.z);
            super.write(dataOutputStream);
        }

        public int getEstimatedSize() {
            return 33;
        }
    }

    public static class PosRot
    extends MovePlayerPacket {
        public PosRot() {
            this.hasRot = true;
            this.hasPos = true;
        }

        public PosRot(double d, double d2, double d3, double d4, float f, float f2, boolean bl) {
            this.x = d;
            this.y = d2;
            this.yView = d3;
            this.z = d4;
            this.yRot = f;
            this.xRot = f2;
            this.onGround = bl;
            this.hasRot = true;
            this.hasPos = true;
        }

        public void read(DataInputStream dataInputStream) throws IOException {
            this.x = dataInputStream.readDouble();
            this.y = dataInputStream.readDouble();
            this.yView = dataInputStream.readDouble();
            this.z = dataInputStream.readDouble();
            this.yRot = dataInputStream.readFloat();
            this.xRot = dataInputStream.readFloat();
            super.read(dataInputStream);
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeDouble(this.x);
            dataOutputStream.writeDouble(this.y);
            dataOutputStream.writeDouble(this.yView);
            dataOutputStream.writeDouble(this.z);
            dataOutputStream.writeFloat(this.yRot);
            dataOutputStream.writeFloat(this.xRot);
            super.write(dataOutputStream);
        }

        public int getEstimatedSize() {
            return 41;
        }
    }
}

