/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.PacketListener;

public class MoveEntityPacket
extends Packet {
    public int id;
    public byte xa;
    public byte ya;
    public byte za;
    public byte yRot;
    public byte xRot;
    public boolean hasRot = false;

    public MoveEntityPacket() {
    }

    public MoveEntityPacket(int n) {
        this.id = n;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.id = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.id);
    }

    public void handle(PacketListener packetListener) {
        packetListener.handleMoveEntity(this);
    }

    public int getEstimatedSize() {
        return 4;
    }

    public static class Rot
    extends MoveEntityPacket {
        public Rot() {
            this.hasRot = true;
        }

        public Rot(int n, byte by, byte by2) {
            super(n);
            this.yRot = by;
            this.xRot = by2;
            this.hasRot = true;
        }

        public void read(DataInputStream dataInputStream) throws IOException {
            super.read(dataInputStream);
            this.yRot = dataInputStream.readByte();
            this.xRot = dataInputStream.readByte();
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            super.write(dataOutputStream);
            dataOutputStream.writeByte(this.yRot);
            dataOutputStream.writeByte(this.xRot);
        }

        public int getEstimatedSize() {
            return 6;
        }
    }

    public static class Pos
    extends MoveEntityPacket {
        public Pos() {
        }

        public Pos(int n, byte by, byte by2, byte by3) {
            super(n);
            this.xa = by;
            this.ya = by2;
            this.za = by3;
        }

        public void read(DataInputStream dataInputStream) throws IOException {
            super.read(dataInputStream);
            this.xa = dataInputStream.readByte();
            this.ya = dataInputStream.readByte();
            this.za = dataInputStream.readByte();
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            super.write(dataOutputStream);
            dataOutputStream.writeByte(this.xa);
            dataOutputStream.writeByte(this.ya);
            dataOutputStream.writeByte(this.za);
        }

        public int getEstimatedSize() {
            return 7;
        }
    }

    public static class PosRot
    extends MoveEntityPacket {
        public PosRot() {
            this.hasRot = true;
        }

        public PosRot(int n, byte by, byte by2, byte by3, byte by4, byte by5) {
            super(n);
            this.xa = by;
            this.ya = by2;
            this.za = by3;
            this.yRot = by4;
            this.xRot = by5;
            this.hasRot = true;
        }

        public void read(DataInputStream dataInputStream) throws IOException {
            super.read(dataInputStream);
            this.xa = dataInputStream.readByte();
            this.ya = dataInputStream.readByte();
            this.za = dataInputStream.readByte();
            this.yRot = dataInputStream.readByte();
            this.xRot = dataInputStream.readByte();
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            super.write(dataOutputStream);
            dataOutputStream.writeByte(this.xa);
            dataOutputStream.writeByte(this.ya);
            dataOutputStream.writeByte(this.za);
            dataOutputStream.writeByte(this.yRot);
            dataOutputStream.writeByte(this.xRot);
        }

        public int getEstimatedSize() {
            return 9;
        }
    }
}

