/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.PacketListener;

public class LoginPacket
extends Packet {
    public int clientVersion;
    public String userName;
    public String loginKey;
    public long seed;
    public byte dimension;

    public LoginPacket() {
    }

    public LoginPacket(String string, String string2, int n) {
        this.userName = string;
        this.loginKey = string2;
        this.clientVersion = n;
    }

    public LoginPacket(String string, String string2, int n, long l, byte by) {
        this.userName = string;
        this.loginKey = string2;
        this.clientVersion = n;
        this.seed = l;
        this.dimension = by;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.clientVersion = dataInputStream.readInt();
        this.userName = dataInputStream.readUTF();
        this.loginKey = dataInputStream.readUTF();
        this.seed = dataInputStream.readLong();
        this.dimension = dataInputStream.readByte();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.clientVersion);
        dataOutputStream.writeUTF(this.userName);
        dataOutputStream.writeUTF(this.loginKey);
        dataOutputStream.writeLong(this.seed);
        dataOutputStream.writeByte(this.dimension);
    }

    public void handle(PacketListener packetListener) {
        packetListener.handleLogin(this);
    }

    public int getEstimatedSize() {
        return 4 + this.userName.length() + this.loginKey.length() + 4 + 5;
    }
}

