/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.PacketListener;

public class InteractPacket
extends Packet {
    public static final int INTERACT = 0;
    public static final int ATTACK = 1;
    public int source;
    public int target;
    public int action;

    public InteractPacket() {
    }

    public InteractPacket(int n, int n2, int n3) {
        this.source = n;
        this.target = n2;
        this.action = n3;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.source = dataInputStream.readInt();
        this.target = dataInputStream.readInt();
        this.action = dataInputStream.readByte();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.source);
        dataOutputStream.writeInt(this.target);
        dataOutputStream.writeByte(this.action);
    }

    public void handle(PacketListener packetListener) {
        packetListener.handleInteract(this);
    }

    public int getEstimatedSize() {
        return 9;
    }
}

