/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.PacketListener;
import net.minecraft.world.level.TilePos;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplodePacket
extends Packet {
    public double x;
    public double y;
    public double z;
    public float r;
    public Set<TilePos> toBlow;

    public ExplodePacket() {
    }

    public ExplodePacket(double d, double d2, double d3, float f, Set<TilePos> set) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.r = f;
        this.toBlow = new HashSet<TilePos>(set);
    }

    @Override
    public void read(DataInputStream dataInputStream) throws IOException {
        this.x = dataInputStream.readDouble();
        this.y = dataInputStream.readDouble();
        this.z = dataInputStream.readDouble();
        this.r = dataInputStream.readFloat();
        int n = dataInputStream.readInt();
        this.toBlow = new HashSet<TilePos>();
        int n2 = (int)this.x;
        int n3 = (int)this.y;
        int n4 = (int)this.z;
        for (int i = 0; i < n; ++i) {
            int n5 = dataInputStream.readByte() + n2;
            int n6 = dataInputStream.readByte() + n3;
            int n7 = dataInputStream.readByte() + n4;
            this.toBlow.add(new TilePos(n5, n6, n7));
        }
    }

    @Override
    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeDouble(this.x);
        dataOutputStream.writeDouble(this.y);
        dataOutputStream.writeDouble(this.z);
        dataOutputStream.writeFloat(this.r);
        dataOutputStream.writeInt(this.toBlow.size());
        int n = (int)this.x;
        int n2 = (int)this.y;
        int n3 = (int)this.z;
        for (TilePos tilePos : this.toBlow) {
            int n4 = tilePos.x - n;
            int n5 = tilePos.y - n2;
            int n6 = tilePos.z - n3;
            dataOutputStream.writeByte(n4);
            dataOutputStream.writeByte(n5);
            dataOutputStream.writeByte(n6);
        }
    }

    @Override
    public void handle(PacketListener packetListener) {
        packetListener.handleExplosion(this);
    }

    @Override
    public int getEstimatedSize() {
        return 32 + this.toBlow.size() * 3;
    }
}

