/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.PacketListener;
import net.minecraft.world.item.ItemInstance;

public class ContainerSetSlotPacket
extends Packet {
    public static final int CONTAINER = 0;
    public static final int WORKBENCH = 1;
    public static final int FURNACE = 2;
    public int containerId;
    public int slot;
    public ItemInstance item;

    public ContainerSetSlotPacket() {
    }

    public ContainerSetSlotPacket(int n, int n2, ItemInstance itemInstance) {
        this.containerId = n;
        this.slot = n2;
        this.item = itemInstance == null ? itemInstance : itemInstance.copy();
    }

    public void handle(PacketListener packetListener) {
        packetListener.handleContainerSetSlot(this);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.containerId = dataInputStream.readByte();
        this.slot = dataInputStream.readShort();
        short s = dataInputStream.readShort();
        if (s >= 0) {
            byte by = dataInputStream.readByte();
            short s2 = dataInputStream.readShort();
            this.item = new ItemInstance(s, (int)by, (int)s2);
        } else {
            this.item = null;
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.containerId);
        dataOutputStream.writeShort(this.slot);
        if (this.item == null) {
            dataOutputStream.writeShort(-1);
        } else {
            dataOutputStream.writeShort(this.item.id);
            dataOutputStream.writeByte(this.item.count);
            dataOutputStream.writeShort(this.item.getAuxValue());
        }
    }

    public int getEstimatedSize() {
        return 8;
    }
}

