/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.PacketListener;
import net.minecraft.world.item.ItemInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerSetContentPacket
extends Packet {
    public int containerId;
    public ItemInstance[] items;

    public ContainerSetContentPacket() {
    }

    public ContainerSetContentPacket(int n, List<ItemInstance> list) {
        this.containerId = n;
        this.items = new ItemInstance[list.size()];
        for (int i = 0; i < this.items.length; ++i) {
            ItemInstance itemInstance = list.get(i);
            this.items[i] = itemInstance == null ? null : itemInstance.copy();
        }
    }

    @Override
    public void read(DataInputStream dataInputStream) throws IOException {
        this.containerId = dataInputStream.readByte();
        int n = dataInputStream.readShort();
        this.items = new ItemInstance[n];
        for (int i = 0; i < n; ++i) {
            short s = dataInputStream.readShort();
            if (s < 0) continue;
            byte by = dataInputStream.readByte();
            short s2 = dataInputStream.readShort();
            this.items[i] = new ItemInstance(s, (int)by, (int)s2);
        }
    }

    @Override
    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.containerId);
        dataOutputStream.writeShort(this.items.length);
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) {
                dataOutputStream.writeShort(-1);
                continue;
            }
            dataOutputStream.writeShort((short)this.items[i].id);
            dataOutputStream.writeByte((byte)this.items[i].count);
            dataOutputStream.writeShort((short)this.items[i].getAuxValue());
        }
    }

    @Override
    public void handle(PacketListener packetListener) {
        packetListener.handleContainerContent(this);
    }

    @Override
    public int getEstimatedSize() {
        return 3 + this.items.length * 5;
    }
}

