/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.PacketListener;

public class ContainerOpenPacket
extends Packet {
    public static final int CONTAINER = 0;
    public static final int WORKBENCH = 1;
    public static final int FURNACE = 2;
    public static final int TRAP = 3;
    public int containerId;
    public int type;
    public String title;
    public int size;

    public ContainerOpenPacket() {
    }

    public ContainerOpenPacket(int n, int n2, String string, int n3) {
        this.containerId = n;
        this.type = n2;
        this.title = string;
        this.size = n3;
    }

    public void handle(PacketListener packetListener) {
        packetListener.handleContainerOpen(this);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.containerId = dataInputStream.readByte();
        this.type = dataInputStream.readByte();
        this.title = dataInputStream.readUTF();
        this.size = dataInputStream.readByte();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.containerId);
        dataOutputStream.writeByte(this.type);
        dataOutputStream.writeUTF(this.title);
        dataOutputStream.writeByte(this.size);
    }

    public int getEstimatedSize() {
        return 3 + this.title.length();
    }
}

